<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductCreate StructType
 * @subpackage Structs
 */
class ProductCreate extends AbstractStructBase
{
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * The productData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PvProductData
     */
    public $productData;
    /**
     * Constructor method for ProductCreate
     * @uses ProductCreate::setCredentials()
     * @uses ProductCreate::setProductData()
     * @param \StructType\ApiCredentials $credentials
     * @param \StructType\PvProductData $productData
     */
    public function __construct(\StructType\ApiCredentials $credentials = null, \StructType\PvProductData $productData = null)
    {
        $this
            ->setCredentials($credentials)
            ->setProductData($productData);
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\ProductCreate
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Get productData value
     * @return \StructType\PvProductData|null
     */
    public function getProductData()
    {
        return $this->productData;
    }
    /**
     * Set productData value
     * @param \StructType\PvProductData $productData
     * @return \StructType\ProductCreate
     */
    public function setProductData(\StructType\PvProductData $productData = null)
    {
        $this->productData = $productData;
        return $this;
    }
}
