<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NotificationMarkAsRead StructType
 * @subpackage Structs
 */
class NotificationMarkAsRead extends AbstractStructBase
{
    /**
     * The userId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $userId;
    /**
     * The activityId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $activityId;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * Constructor method for NotificationMarkAsRead
     * @uses NotificationMarkAsRead::setUserId()
     * @uses NotificationMarkAsRead::setActivityId()
     * @uses NotificationMarkAsRead::setCredentials()
     * @param string $userId
     * @param string $activityId
     * @param \StructType\ApiCredentials $credentials
     */
    public function __construct($userId = null, $activityId = null, \StructType\ApiCredentials $credentials = null)
    {
        $this
            ->setUserId($userId)
            ->setActivityId($activityId)
            ->setCredentials($credentials);
    }
    /**
     * Get userId value
     * @return string
     */
    public function getUserId()
    {
        return $this->userId;
    }
    /**
     * Set userId value
     * @param string $userId
     * @return \StructType\NotificationMarkAsRead
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($userId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($userId, true)), __LINE__);
        }
        $this->userId = $userId;
        return $this;
    }
    /**
     * Get activityId value
     * @return string
     */
    public function getActivityId()
    {
        return $this->activityId;
    }
    /**
     * Set activityId value
     * @param string $activityId
     * @return \StructType\NotificationMarkAsRead
     */
    public function setActivityId($activityId = null)
    {
        // validation for constraint: string
        if (!is_null($activityId) && !is_string($activityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityId, true), gettype($activityId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($activityId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $activityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($activityId, true)), __LINE__);
        }
        $this->activityId = $activityId;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\NotificationMarkAsRead
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
}
