<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NoteExists StructType
 * @subpackage Structs
 */
class NoteExists extends AbstractStructBase
{
    /**
     * The NoteId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $NoteId;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * Constructor method for NoteExists
     * @uses NoteExists::setNoteId()
     * @uses NoteExists::setCredentials()
     * @param string $noteId
     * @param \StructType\ApiCredentials $credentials
     */
    public function __construct($noteId = null, \StructType\ApiCredentials $credentials = null)
    {
        $this
            ->setNoteId($noteId)
            ->setCredentials($credentials);
    }
    /**
     * Get NoteId value
     * @return string
     */
    public function getNoteId()
    {
        return $this->NoteId;
    }
    /**
     * Set NoteId value
     * @param string $noteId
     * @return \StructType\NoteExists
     */
    public function setNoteId($noteId = null)
    {
        // validation for constraint: string
        if (!is_null($noteId) && !is_string($noteId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noteId, true), gettype($noteId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($noteId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $noteId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($noteId, true)), __LINE__);
        }
        $this->NoteId = $noteId;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\NoteExists
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
}
