<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MobileLogError StructType
 * @subpackage Structs
 */
class MobileLogError extends AbstractStructBase
{
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * The error
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $error;
    /**
     * Constructor method for MobileLogError
     * @uses MobileLogError::setCredentials()
     * @uses MobileLogError::setError()
     * @param \StructType\ApiCredentials $credentials
     * @param string $error
     */
    public function __construct(\StructType\ApiCredentials $credentials = null, $error = null)
    {
        $this
            ->setCredentials($credentials)
            ->setError($error);
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\MobileLogError
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Get error value
     * @return string|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @param string $error
     * @return \StructType\MobileLogError
     */
    public function setError($error = null)
    {
        // validation for constraint: string
        if (!is_null($error) && !is_string($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($error, true), gettype($error)), __LINE__);
        }
        $this->error = $error;
        return $this;
    }
}
