<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MobileGetTranslations StructType
 * @subpackage Structs
 */
class MobileGetTranslations extends AbstractStructBase
{
    /**
     * The apiKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $apiKey;
    /**
     * The deviceOs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $deviceOs;
    /**
     * Constructor method for MobileGetTranslations
     * @uses MobileGetTranslations::setApiKey()
     * @uses MobileGetTranslations::setDeviceOs()
     * @param string $apiKey
     * @param string $deviceOs
     */
    public function __construct($apiKey = null, $deviceOs = null)
    {
        $this
            ->setApiKey($apiKey)
            ->setDeviceOs($deviceOs);
    }
    /**
     * Get apiKey value
     * @return string
     */
    public function getApiKey()
    {
        return $this->apiKey;
    }
    /**
     * Set apiKey value
     * @param string $apiKey
     * @return \StructType\MobileGetTranslations
     */
    public function setApiKey($apiKey = null)
    {
        // validation for constraint: string
        if (!is_null($apiKey) && !is_string($apiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apiKey, true), gettype($apiKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($apiKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $apiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($apiKey, true)), __LINE__);
        }
        $this->apiKey = $apiKey;
        return $this;
    }
    /**
     * Get deviceOs value
     * @return string
     */
    public function getDeviceOs()
    {
        return $this->deviceOs;
    }
    /**
     * Set deviceOs value
     * @uses \EnumType\MobileDeviceOsType::valueIsValid()
     * @uses \EnumType\MobileDeviceOsType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceOs
     * @return \StructType\MobileGetTranslations
     */
    public function setDeviceOs($deviceOs = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MobileDeviceOsType::valueIsValid($deviceOs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\MobileDeviceOsType', is_array($deviceOs) ? implode(', ', $deviceOs) : var_export($deviceOs, true), implode(', ', \EnumType\MobileDeviceOsType::getValidValues())), __LINE__);
        }
        $this->deviceOs = $deviceOs;
        return $this;
    }
}
