<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MobileGetCreateAccountDatastore StructType
 * @subpackage Structs
 */
class MobileGetCreateAccountDatastore extends AbstractStructBase
{
    /**
     * The apiKey
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $apiKey;
    /**
     * The datastoreType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $datastoreType;
    /**
     * The cultureCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cultureCode;
    /**
     * Constructor method for MobileGetCreateAccountDatastore
     * @uses MobileGetCreateAccountDatastore::setApiKey()
     * @uses MobileGetCreateAccountDatastore::setDatastoreType()
     * @uses MobileGetCreateAccountDatastore::setCultureCode()
     * @param string $apiKey
     * @param string $datastoreType
     * @param string $cultureCode
     */
    public function __construct($apiKey = null, $datastoreType = null, $cultureCode = null)
    {
        $this
            ->setApiKey($apiKey)
            ->setDatastoreType($datastoreType)
            ->setCultureCode($cultureCode);
    }
    /**
     * Get apiKey value
     * @return string
     */
    public function getApiKey()
    {
        return $this->apiKey;
    }
    /**
     * Set apiKey value
     * @param string $apiKey
     * @return \StructType\MobileGetCreateAccountDatastore
     */
    public function setApiKey($apiKey = null)
    {
        // validation for constraint: string
        if (!is_null($apiKey) && !is_string($apiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apiKey, true), gettype($apiKey)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($apiKey) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $apiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($apiKey, true)), __LINE__);
        }
        $this->apiKey = $apiKey;
        return $this;
    }
    /**
     * Get datastoreType value
     * @return string
     */
    public function getDatastoreType()
    {
        return $this->datastoreType;
    }
    /**
     * Set datastoreType value
     * @uses \EnumType\CreateAccountDatastoreType::valueIsValid()
     * @uses \EnumType\CreateAccountDatastoreType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $datastoreType
     * @return \StructType\MobileGetCreateAccountDatastore
     */
    public function setDatastoreType($datastoreType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CreateAccountDatastoreType::valueIsValid($datastoreType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CreateAccountDatastoreType', is_array($datastoreType) ? implode(', ', $datastoreType) : var_export($datastoreType, true), implode(', ', \EnumType\CreateAccountDatastoreType::getValidValues())), __LINE__);
        }
        $this->datastoreType = $datastoreType;
        return $this;
    }
    /**
     * Get cultureCode value
     * @return string|null
     */
    public function getCultureCode()
    {
        return $this->cultureCode;
    }
    /**
     * Set cultureCode value
     * @param string $cultureCode
     * @return \StructType\MobileGetCreateAccountDatastore
     */
    public function setCultureCode($cultureCode = null)
    {
        // validation for constraint: string
        if (!is_null($cultureCode) && !is_string($cultureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cultureCode, true), gettype($cultureCode)), __LINE__);
        }
        $this->cultureCode = $cultureCode;
        return $this;
    }
}
