<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EnumerationGetItems StructType
 * @subpackage Structs
 */
class EnumerationGetItems extends AbstractStructBase
{
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * The enumerationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $enumerationName;
    /**
     * Constructor method for EnumerationGetItems
     * @uses EnumerationGetItems::setCredentials()
     * @uses EnumerationGetItems::setEnumerationName()
     * @param \StructType\ApiCredentials $credentials
     * @param string $enumerationName
     */
    public function __construct(\StructType\ApiCredentials $credentials = null, $enumerationName = null)
    {
        $this
            ->setCredentials($credentials)
            ->setEnumerationName($enumerationName);
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\EnumerationGetItems
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Get enumerationName value
     * @return string|null
     */
    public function getEnumerationName()
    {
        return $this->enumerationName;
    }
    /**
     * Set enumerationName value
     * @param string $enumerationName
     * @return \StructType\EnumerationGetItems
     */
    public function setEnumerationName($enumerationName = null)
    {
        // validation for constraint: string
        if (!is_null($enumerationName) && !is_string($enumerationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enumerationName, true), gettype($enumerationName)), __LINE__);
        }
        $this->enumerationName = $enumerationName;
        return $this;
    }
}
