<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DatastoreUpdateItem_V2 StructType
 * @subpackage Structs
 */
class DatastoreUpdateItem_V2 extends AbstractStructBase
{
    /**
     * The dataStoreId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $dataStoreId;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * The fieldValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPvFieldValueData
     */
    public $fieldValues;
    /**
     * The translations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPvTranslationData2
     */
    public $translations;
    /**
     * Constructor method for DatastoreUpdateItem_V2
     * @uses DatastoreUpdateItem_V2::setDataStoreId()
     * @uses DatastoreUpdateItem_V2::setCredentials()
     * @uses DatastoreUpdateItem_V2::setFieldValues()
     * @uses DatastoreUpdateItem_V2::setTranslations()
     * @param string $dataStoreId
     * @param \StructType\ApiCredentials $credentials
     * @param \ArrayType\ArrayOfPvFieldValueData $fieldValues
     * @param \ArrayType\ArrayOfPvTranslationData2 $translations
     */
    public function __construct($dataStoreId = null, \StructType\ApiCredentials $credentials = null, \ArrayType\ArrayOfPvFieldValueData $fieldValues = null, \ArrayType\ArrayOfPvTranslationData2 $translations = null)
    {
        $this
            ->setDataStoreId($dataStoreId)
            ->setCredentials($credentials)
            ->setFieldValues($fieldValues)
            ->setTranslations($translations);
    }
    /**
     * Get dataStoreId value
     * @return string
     */
    public function getDataStoreId()
    {
        return $this->dataStoreId;
    }
    /**
     * Set dataStoreId value
     * @param string $dataStoreId
     * @return \StructType\DatastoreUpdateItem_V2
     */
    public function setDataStoreId($dataStoreId = null)
    {
        // validation for constraint: string
        if (!is_null($dataStoreId) && !is_string($dataStoreId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataStoreId, true), gettype($dataStoreId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($dataStoreId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $dataStoreId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($dataStoreId, true)), __LINE__);
        }
        $this->dataStoreId = $dataStoreId;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\DatastoreUpdateItem_V2
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Get fieldValues value
     * @return \ArrayType\ArrayOfPvFieldValueData|null
     */
    public function getFieldValues()
    {
        return $this->fieldValues;
    }
    /**
     * Set fieldValues value
     * @param \ArrayType\ArrayOfPvFieldValueData $fieldValues
     * @return \StructType\DatastoreUpdateItem_V2
     */
    public function setFieldValues(\ArrayType\ArrayOfPvFieldValueData $fieldValues = null)
    {
        $this->fieldValues = $fieldValues;
        return $this;
    }
    /**
     * Get translations value
     * @return \ArrayType\ArrayOfPvTranslationData2|null
     */
    public function getTranslations()
    {
        return $this->translations;
    }
    /**
     * Set translations value
     * @param \ArrayType\ArrayOfPvTranslationData2 $translations
     * @return \StructType\DatastoreUpdateItem_V2
     */
    public function setTranslations(\ArrayType\ArrayOfPvTranslationData2 $translations = null)
    {
        $this->translations = $translations;
        return $this;
    }
}
