<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DatastoreUpdateItem StructType
 * @subpackage Structs
 */
class DatastoreUpdateItem extends AbstractStructBase
{
    /**
     * The dataStoreId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $dataStoreId;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * The fieldValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPvFieldValueData
     */
    public $fieldValues;
    /**
     * Constructor method for DatastoreUpdateItem
     * @uses DatastoreUpdateItem::setDataStoreId()
     * @uses DatastoreUpdateItem::setCredentials()
     * @uses DatastoreUpdateItem::setFieldValues()
     * @param string $dataStoreId
     * @param \StructType\ApiCredentials $credentials
     * @param \ArrayType\ArrayOfPvFieldValueData $fieldValues
     */
    public function __construct($dataStoreId = null, \StructType\ApiCredentials $credentials = null, \ArrayType\ArrayOfPvFieldValueData $fieldValues = null)
    {
        $this
            ->setDataStoreId($dataStoreId)
            ->setCredentials($credentials)
            ->setFieldValues($fieldValues);
    }
    /**
     * Get dataStoreId value
     * @return string
     */
    public function getDataStoreId()
    {
        return $this->dataStoreId;
    }
    /**
     * Set dataStoreId value
     * @param string $dataStoreId
     * @return \StructType\DatastoreUpdateItem
     */
    public function setDataStoreId($dataStoreId = null)
    {
        // validation for constraint: string
        if (!is_null($dataStoreId) && !is_string($dataStoreId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataStoreId, true), gettype($dataStoreId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($dataStoreId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $dataStoreId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($dataStoreId, true)), __LINE__);
        }
        $this->dataStoreId = $dataStoreId;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\DatastoreUpdateItem
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Get fieldValues value
     * @return \ArrayType\ArrayOfPvFieldValueData|null
     */
    public function getFieldValues()
    {
        return $this->fieldValues;
    }
    /**
     * Set fieldValues value
     * @param \ArrayType\ArrayOfPvFieldValueData $fieldValues
     * @return \StructType\DatastoreUpdateItem
     */
    public function setFieldValues(\ArrayType\ArrayOfPvFieldValueData $fieldValues = null)
    {
        $this->fieldValues = $fieldValues;
        return $this;
    }
}
