<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DatastoreGetItems_V2 StructType
 * @subpackage Structs
 */
class DatastoreGetItems_V2 extends AbstractStructBase
{
    /**
     * The entityTypeId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $entityTypeId;
    /**
     * The pageSize
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pageSize;
    /**
     * The pageNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pageNumber;
    /**
     * The includeTranslations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $includeTranslations;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * Constructor method for DatastoreGetItems_V2
     * @uses DatastoreGetItems_V2::setEntityTypeId()
     * @uses DatastoreGetItems_V2::setPageSize()
     * @uses DatastoreGetItems_V2::setPageNumber()
     * @uses DatastoreGetItems_V2::setIncludeTranslations()
     * @uses DatastoreGetItems_V2::setCredentials()
     * @param string $entityTypeId
     * @param int $pageSize
     * @param int $pageNumber
     * @param bool $includeTranslations
     * @param \StructType\ApiCredentials $credentials
     */
    public function __construct($entityTypeId = null, $pageSize = null, $pageNumber = null, $includeTranslations = null, \StructType\ApiCredentials $credentials = null)
    {
        $this
            ->setEntityTypeId($entityTypeId)
            ->setPageSize($pageSize)
            ->setPageNumber($pageNumber)
            ->setIncludeTranslations($includeTranslations)
            ->setCredentials($credentials);
    }
    /**
     * Get entityTypeId value
     * @return string
     */
    public function getEntityTypeId()
    {
        return $this->entityTypeId;
    }
    /**
     * Set entityTypeId value
     * @param string $entityTypeId
     * @return \StructType\DatastoreGetItems_V2
     */
    public function setEntityTypeId($entityTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($entityTypeId) && !is_string($entityTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityTypeId, true), gettype($entityTypeId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($entityTypeId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $entityTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($entityTypeId, true)), __LINE__);
        }
        $this->entityTypeId = $entityTypeId;
        return $this;
    }
    /**
     * Get pageSize value
     * @return int
     */
    public function getPageSize()
    {
        return $this->pageSize;
    }
    /**
     * Set pageSize value
     * @param int $pageSize
     * @return \StructType\DatastoreGetItems_V2
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: int
        if (!is_null($pageSize) && !(is_int($pageSize) || ctype_digit($pageSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageSize, true), gettype($pageSize)), __LINE__);
        }
        $this->pageSize = $pageSize;
        return $this;
    }
    /**
     * Get pageNumber value
     * @return int
     */
    public function getPageNumber()
    {
        return $this->pageNumber;
    }
    /**
     * Set pageNumber value
     * @param int $pageNumber
     * @return \StructType\DatastoreGetItems_V2
     */
    public function setPageNumber($pageNumber = null)
    {
        // validation for constraint: int
        if (!is_null($pageNumber) && !(is_int($pageNumber) || ctype_digit($pageNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageNumber, true), gettype($pageNumber)), __LINE__);
        }
        $this->pageNumber = $pageNumber;
        return $this;
    }
    /**
     * Get includeTranslations value
     * @return bool
     */
    public function getIncludeTranslations()
    {
        return $this->includeTranslations;
    }
    /**
     * Set includeTranslations value
     * @param bool $includeTranslations
     * @return \StructType\DatastoreGetItems_V2
     */
    public function setIncludeTranslations($includeTranslations = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeTranslations) && !is_bool($includeTranslations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeTranslations, true), gettype($includeTranslations)), __LINE__);
        }
        $this->includeTranslations = $includeTranslations;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\DatastoreGetItems_V2
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
}
