<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DatastoreCreateItemResult_V3 StructType
 * @subpackage Structs
 */
class DatastoreCreateItemResult_V3 extends PvApiResult
{
    /**
     * The DatastoreItem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PvDatastoreItemData_V3
     */
    public $DatastoreItem;
    /**
     * The ErrorInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorInformation;
    /**
     * Constructor method for DatastoreCreateItemResult_V3
     * @uses DatastoreCreateItemResult_V3::setDatastoreItem()
     * @uses DatastoreCreateItemResult_V3::setErrorInformation()
     * @param \StructType\PvDatastoreItemData_V3 $datastoreItem
     * @param string $errorInformation
     */
    public function __construct(\StructType\PvDatastoreItemData_V3 $datastoreItem = null, $errorInformation = null)
    {
        $this
            ->setDatastoreItem($datastoreItem)
            ->setErrorInformation($errorInformation);
    }
    /**
     * Get DatastoreItem value
     * @return \StructType\PvDatastoreItemData_V3|null
     */
    public function getDatastoreItem()
    {
        return $this->DatastoreItem;
    }
    /**
     * Set DatastoreItem value
     * @param \StructType\PvDatastoreItemData_V3 $datastoreItem
     * @return \StructType\DatastoreCreateItemResult_V3
     */
    public function setDatastoreItem(\StructType\PvDatastoreItemData_V3 $datastoreItem = null)
    {
        $this->DatastoreItem = $datastoreItem;
        return $this;
    }
    /**
     * Get ErrorInformation value
     * @return string|null
     */
    public function getErrorInformation()
    {
        return $this->ErrorInformation;
    }
    /**
     * Set ErrorInformation value
     * @param string $errorInformation
     * @return \StructType\DatastoreCreateItemResult_V3
     */
    public function setErrorInformation($errorInformation = null)
    {
        // validation for constraint: string
        if (!is_null($errorInformation) && !is_string($errorInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorInformation, true), gettype($errorInformation)), __LINE__);
        }
        $this->ErrorInformation = $errorInformation;
        return $this;
    }
}
