<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DatastoreCreateItem StructType
 * @subpackage Structs
 */
class DatastoreCreateItem extends AbstractStructBase
{
    /**
     * The entityTypeId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $entityTypeId;
    /**
     * The isDefault
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $isDefault;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $value;
    /**
     * Constructor method for DatastoreCreateItem
     * @uses DatastoreCreateItem::setEntityTypeId()
     * @uses DatastoreCreateItem::setIsDefault()
     * @uses DatastoreCreateItem::setCredentials()
     * @uses DatastoreCreateItem::setValue()
     * @param string $entityTypeId
     * @param bool $isDefault
     * @param \StructType\ApiCredentials $credentials
     * @param string $value
     */
    public function __construct($entityTypeId = null, $isDefault = null, \StructType\ApiCredentials $credentials = null, $value = null)
    {
        $this
            ->setEntityTypeId($entityTypeId)
            ->setIsDefault($isDefault)
            ->setCredentials($credentials)
            ->setValue($value);
    }
    /**
     * Get entityTypeId value
     * @return string
     */
    public function getEntityTypeId()
    {
        return $this->entityTypeId;
    }
    /**
     * Set entityTypeId value
     * @param string $entityTypeId
     * @return \StructType\DatastoreCreateItem
     */
    public function setEntityTypeId($entityTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($entityTypeId) && !is_string($entityTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityTypeId, true), gettype($entityTypeId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($entityTypeId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $entityTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($entityTypeId, true)), __LINE__);
        }
        $this->entityTypeId = $entityTypeId;
        return $this;
    }
    /**
     * Get isDefault value
     * @return bool
     */
    public function getIsDefault()
    {
        return $this->isDefault;
    }
    /**
     * Set isDefault value
     * @param bool $isDefault
     * @return \StructType\DatastoreCreateItem
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDefault) && !is_bool($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDefault, true), gettype($isDefault)), __LINE__);
        }
        $this->isDefault = $isDefault;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\DatastoreCreateItem
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \StructType\DatastoreCreateItem
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
}
