<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AttachmentUpdate StructType
 * @subpackage Structs
 */
class AttachmentUpdate extends AbstractStructBase
{
    /**
     * The attachmentId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $attachmentId;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * The fileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $fileName;
    /**
     * The base64EncodedFile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $base64EncodedFile;
    /**
     * Constructor method for AttachmentUpdate
     * @uses AttachmentUpdate::setAttachmentId()
     * @uses AttachmentUpdate::setCredentials()
     * @uses AttachmentUpdate::setFileName()
     * @uses AttachmentUpdate::setBase64EncodedFile()
     * @param string $attachmentId
     * @param \StructType\ApiCredentials $credentials
     * @param string $fileName
     * @param string $base64EncodedFile
     */
    public function __construct($attachmentId = null, \StructType\ApiCredentials $credentials = null, $fileName = null, $base64EncodedFile = null)
    {
        $this
            ->setAttachmentId($attachmentId)
            ->setCredentials($credentials)
            ->setFileName($fileName)
            ->setBase64EncodedFile($base64EncodedFile);
    }
    /**
     * Get attachmentId value
     * @return string
     */
    public function getAttachmentId()
    {
        return $this->attachmentId;
    }
    /**
     * Set attachmentId value
     * @param string $attachmentId
     * @return \StructType\AttachmentUpdate
     */
    public function setAttachmentId($attachmentId = null)
    {
        // validation for constraint: string
        if (!is_null($attachmentId) && !is_string($attachmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attachmentId, true), gettype($attachmentId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($attachmentId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $attachmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($attachmentId, true)), __LINE__);
        }
        $this->attachmentId = $attachmentId;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\AttachmentUpdate
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Get fileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->fileName;
    }
    /**
     * Set fileName value
     * @param string $fileName
     * @return \StructType\AttachmentUpdate
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        $this->fileName = $fileName;
        return $this;
    }
    /**
     * Get base64EncodedFile value
     * @return string|null
     */
    public function getBase64EncodedFile()
    {
        return $this->base64EncodedFile;
    }
    /**
     * Set base64EncodedFile value
     * @param string $base64EncodedFile
     * @return \StructType\AttachmentUpdate
     */
    public function setBase64EncodedFile($base64EncodedFile = null)
    {
        // validation for constraint: string
        if (!is_null($base64EncodedFile) && !is_string($base64EncodedFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($base64EncodedFile, true), gettype($base64EncodedFile)), __LINE__);
        }
        $this->base64EncodedFile = $base64EncodedFile;
        return $this;
    }
}
