<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AttachmentGetGoogleDocsUrl StructType
 * @subpackage Structs
 */
class AttachmentGetGoogleDocsUrl extends AbstractStructBase
{
    /**
     * The attachmentId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $attachmentId;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * Constructor method for AttachmentGetGoogleDocsUrl
     * @uses AttachmentGetGoogleDocsUrl::setAttachmentId()
     * @uses AttachmentGetGoogleDocsUrl::setCredentials()
     * @param string $attachmentId
     * @param \StructType\ApiCredentials $credentials
     */
    public function __construct($attachmentId = null, \StructType\ApiCredentials $credentials = null)
    {
        $this
            ->setAttachmentId($attachmentId)
            ->setCredentials($credentials);
    }
    /**
     * Get attachmentId value
     * @return string
     */
    public function getAttachmentId()
    {
        return $this->attachmentId;
    }
    /**
     * Set attachmentId value
     * @param string $attachmentId
     * @return \StructType\AttachmentGetGoogleDocsUrl
     */
    public function setAttachmentId($attachmentId = null)
    {
        // validation for constraint: string
        if (!is_null($attachmentId) && !is_string($attachmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attachmentId, true), gettype($attachmentId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($attachmentId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $attachmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($attachmentId, true)), __LINE__);
        }
        $this->attachmentId = $attachmentId;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\AttachmentGetGoogleDocsUrl
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
}
