<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AttachmentAddLabel StructType
 * @subpackage Structs
 */
class AttachmentAddLabel extends AbstractStructBase
{
    /**
     * The attachmentId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $attachmentId;
    /**
     * The datastoreId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $datastoreId;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * Constructor method for AttachmentAddLabel
     * @uses AttachmentAddLabel::setAttachmentId()
     * @uses AttachmentAddLabel::setDatastoreId()
     * @uses AttachmentAddLabel::setCredentials()
     * @param string $attachmentId
     * @param string $datastoreId
     * @param \StructType\ApiCredentials $credentials
     */
    public function __construct($attachmentId = null, $datastoreId = null, \StructType\ApiCredentials $credentials = null)
    {
        $this
            ->setAttachmentId($attachmentId)
            ->setDatastoreId($datastoreId)
            ->setCredentials($credentials);
    }
    /**
     * Get attachmentId value
     * @return string
     */
    public function getAttachmentId()
    {
        return $this->attachmentId;
    }
    /**
     * Set attachmentId value
     * @param string $attachmentId
     * @return \StructType\AttachmentAddLabel
     */
    public function setAttachmentId($attachmentId = null)
    {
        // validation for constraint: string
        if (!is_null($attachmentId) && !is_string($attachmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attachmentId, true), gettype($attachmentId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($attachmentId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $attachmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($attachmentId, true)), __LINE__);
        }
        $this->attachmentId = $attachmentId;
        return $this;
    }
    /**
     * Get datastoreId value
     * @return string
     */
    public function getDatastoreId()
    {
        return $this->datastoreId;
    }
    /**
     * Set datastoreId value
     * @param string $datastoreId
     * @return \StructType\AttachmentAddLabel
     */
    public function setDatastoreId($datastoreId = null)
    {
        // validation for constraint: string
        if (!is_null($datastoreId) && !is_string($datastoreId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datastoreId, true), gettype($datastoreId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($datastoreId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $datastoreId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($datastoreId, true)), __LINE__);
        }
        $this->datastoreId = $datastoreId;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\AttachmentAddLabel
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
}
