<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityViewGetData StructType
 * @subpackage Structs
 */
class ActivityViewGetData extends AbstractStructBase
{
    /**
     * The pageNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pageNumber;
    /**
     * The pageSize
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pageSize;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * The viewSql
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $viewSql;
    /**
     * The sortingColumn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sortingColumn;
    /**
     * The searchText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $searchText;
    /**
     * The fieldIds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfGuid
     */
    public $fieldIds;
    /**
     * Constructor method for ActivityViewGetData
     * @uses ActivityViewGetData::setPageNumber()
     * @uses ActivityViewGetData::setPageSize()
     * @uses ActivityViewGetData::setCredentials()
     * @uses ActivityViewGetData::setViewSql()
     * @uses ActivityViewGetData::setSortingColumn()
     * @uses ActivityViewGetData::setSearchText()
     * @uses ActivityViewGetData::setFieldIds()
     * @param int $pageNumber
     * @param int $pageSize
     * @param \StructType\ApiCredentials $credentials
     * @param string $viewSql
     * @param string $sortingColumn
     * @param string $searchText
     * @param \ArrayType\ArrayOfGuid $fieldIds
     */
    public function __construct($pageNumber = null, $pageSize = null, \StructType\ApiCredentials $credentials = null, $viewSql = null, $sortingColumn = null, $searchText = null, \ArrayType\ArrayOfGuid $fieldIds = null)
    {
        $this
            ->setPageNumber($pageNumber)
            ->setPageSize($pageSize)
            ->setCredentials($credentials)
            ->setViewSql($viewSql)
            ->setSortingColumn($sortingColumn)
            ->setSearchText($searchText)
            ->setFieldIds($fieldIds);
    }
    /**
     * Get pageNumber value
     * @return int
     */
    public function getPageNumber()
    {
        return $this->pageNumber;
    }
    /**
     * Set pageNumber value
     * @param int $pageNumber
     * @return \StructType\ActivityViewGetData
     */
    public function setPageNumber($pageNumber = null)
    {
        // validation for constraint: int
        if (!is_null($pageNumber) && !(is_int($pageNumber) || ctype_digit($pageNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageNumber, true), gettype($pageNumber)), __LINE__);
        }
        $this->pageNumber = $pageNumber;
        return $this;
    }
    /**
     * Get pageSize value
     * @return int
     */
    public function getPageSize()
    {
        return $this->pageSize;
    }
    /**
     * Set pageSize value
     * @param int $pageSize
     * @return \StructType\ActivityViewGetData
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: int
        if (!is_null($pageSize) && !(is_int($pageSize) || ctype_digit($pageSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageSize, true), gettype($pageSize)), __LINE__);
        }
        $this->pageSize = $pageSize;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\ActivityViewGetData
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Get viewSql value
     * @return string|null
     */
    public function getViewSql()
    {
        return $this->viewSql;
    }
    /**
     * Set viewSql value
     * @param string $viewSql
     * @return \StructType\ActivityViewGetData
     */
    public function setViewSql($viewSql = null)
    {
        // validation for constraint: string
        if (!is_null($viewSql) && !is_string($viewSql)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($viewSql, true), gettype($viewSql)), __LINE__);
        }
        $this->viewSql = $viewSql;
        return $this;
    }
    /**
     * Get sortingColumn value
     * @return string|null
     */
    public function getSortingColumn()
    {
        return $this->sortingColumn;
    }
    /**
     * Set sortingColumn value
     * @param string $sortingColumn
     * @return \StructType\ActivityViewGetData
     */
    public function setSortingColumn($sortingColumn = null)
    {
        // validation for constraint: string
        if (!is_null($sortingColumn) && !is_string($sortingColumn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sortingColumn, true), gettype($sortingColumn)), __LINE__);
        }
        $this->sortingColumn = $sortingColumn;
        return $this;
    }
    /**
     * Get searchText value
     * @return string|null
     */
    public function getSearchText()
    {
        return $this->searchText;
    }
    /**
     * Set searchText value
     * @param string $searchText
     * @return \StructType\ActivityViewGetData
     */
    public function setSearchText($searchText = null)
    {
        // validation for constraint: string
        if (!is_null($searchText) && !is_string($searchText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchText, true), gettype($searchText)), __LINE__);
        }
        $this->searchText = $searchText;
        return $this;
    }
    /**
     * Get fieldIds value
     * @return \ArrayType\ArrayOfGuid|null
     */
    public function getFieldIds()
    {
        return $this->fieldIds;
    }
    /**
     * Set fieldIds value
     * @param \ArrayType\ArrayOfGuid $fieldIds
     * @return \StructType\ActivityViewGetData
     */
    public function setFieldIds(\ArrayType\ArrayOfGuid $fieldIds = null)
    {
        $this->fieldIds = $fieldIds;
        return $this;
    }
}
