<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityParameter StructType
 * @subpackage Structs
 */
class ActivityParameter extends AbstractStructBase
{
    /**
     * The parameter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $parameter;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $value;
    /**
     * Constructor method for ActivityParameter
     * @uses ActivityParameter::setParameter()
     * @uses ActivityParameter::setValue()
     * @param string $parameter
     * @param string $value
     */
    public function __construct($parameter = null, $value = null)
    {
        $this
            ->setParameter($parameter)
            ->setValue($value);
    }
    /**
     * Get parameter value
     * @return string
     */
    public function getParameter()
    {
        return $this->parameter;
    }
    /**
     * Set parameter value
     * @uses \EnumType\ActivityExtraParameter::valueIsValid()
     * @uses \EnumType\ActivityExtraParameter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $parameter
     * @return \StructType\ActivityParameter
     */
    public function setParameter($parameter = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActivityExtraParameter::valueIsValid($parameter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ActivityExtraParameter', is_array($parameter) ? implode(', ', $parameter) : var_export($parameter, true), implode(', ', \EnumType\ActivityExtraParameter::getValidValues())), __LINE__);
        }
        $this->parameter = $parameter;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \StructType\ActivityParameter
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
}
