<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityInvolvedEntityTypesGet StructType
 * @subpackage Structs
 */
class ActivityInvolvedEntityTypesGet extends AbstractStructBase
{
    /**
     * The activityEntityTypeId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $activityEntityTypeId;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * Constructor method for ActivityInvolvedEntityTypesGet
     * @uses ActivityInvolvedEntityTypesGet::setActivityEntityTypeId()
     * @uses ActivityInvolvedEntityTypesGet::setCredentials()
     * @param string $activityEntityTypeId
     * @param \StructType\ApiCredentials $credentials
     */
    public function __construct($activityEntityTypeId = null, \StructType\ApiCredentials $credentials = null)
    {
        $this
            ->setActivityEntityTypeId($activityEntityTypeId)
            ->setCredentials($credentials);
    }
    /**
     * Get activityEntityTypeId value
     * @return string
     */
    public function getActivityEntityTypeId()
    {
        return $this->activityEntityTypeId;
    }
    /**
     * Set activityEntityTypeId value
     * @param string $activityEntityTypeId
     * @return \StructType\ActivityInvolvedEntityTypesGet
     */
    public function setActivityEntityTypeId($activityEntityTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($activityEntityTypeId) && !is_string($activityEntityTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityEntityTypeId, true), gettype($activityEntityTypeId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($activityEntityTypeId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $activityEntityTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($activityEntityTypeId, true)), __LINE__);
        }
        $this->activityEntityTypeId = $activityEntityTypeId;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\ActivityInvolvedEntityTypesGet
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
}
