<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityDeleteProductLine StructType
 * @subpackage Structs
 */
class ActivityDeleteProductLine extends AbstractStructBase
{
    /**
     * The productLineId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $productLineId;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * Constructor method for ActivityDeleteProductLine
     * @uses ActivityDeleteProductLine::setProductLineId()
     * @uses ActivityDeleteProductLine::setCredentials()
     * @param string $productLineId
     * @param \StructType\ApiCredentials $credentials
     */
    public function __construct($productLineId = null, \StructType\ApiCredentials $credentials = null)
    {
        $this
            ->setProductLineId($productLineId)
            ->setCredentials($credentials);
    }
    /**
     * Get productLineId value
     * @return string
     */
    public function getProductLineId()
    {
        return $this->productLineId;
    }
    /**
     * Set productLineId value
     * @param string $productLineId
     * @return \StructType\ActivityDeleteProductLine
     */
    public function setProductLineId($productLineId = null)
    {
        // validation for constraint: string
        if (!is_null($productLineId) && !is_string($productLineId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productLineId, true), gettype($productLineId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($productLineId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $productLineId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($productLineId, true)), __LINE__);
        }
        $this->productLineId = $productLineId;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\ActivityDeleteProductLine
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
}
