<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityCreateResult StructType
 * @subpackage Structs
 */
class ActivityCreateResult extends PvApiResult
{
    /**
     * The Activity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PvActivityData
     */
    public $Activity;
    /**
     * The ErrorInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorInformation;
    /**
     * Constructor method for ActivityCreateResult
     * @uses ActivityCreateResult::setActivity()
     * @uses ActivityCreateResult::setErrorInformation()
     * @param \StructType\PvActivityData $activity
     * @param string $errorInformation
     */
    public function __construct(\StructType\PvActivityData $activity = null, $errorInformation = null)
    {
        $this
            ->setActivity($activity)
            ->setErrorInformation($errorInformation);
    }
    /**
     * Get Activity value
     * @return \StructType\PvActivityData|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * Set Activity value
     * @param \StructType\PvActivityData $activity
     * @return \StructType\ActivityCreateResult
     */
    public function setActivity(\StructType\PvActivityData $activity = null)
    {
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Get ErrorInformation value
     * @return string|null
     */
    public function getErrorInformation()
    {
        return $this->ErrorInformation;
    }
    /**
     * Set ErrorInformation value
     * @param string $errorInformation
     * @return \StructType\ActivityCreateResult
     */
    public function setErrorInformation($errorInformation = null)
    {
        // validation for constraint: string
        if (!is_null($errorInformation) && !is_string($errorInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorInformation, true), gettype($errorInformation)), __LINE__);
        }
        $this->ErrorInformation = $errorInformation;
        return $this;
    }
}
