<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityCreate StructType
 * @subpackage Structs
 */
class ActivityCreate extends AbstractStructBase
{
    /**
     * The connectToActivityId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $connectToActivityId;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * The settings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PvActivitySettingsData
     */
    public $settings;
    /**
     * The followUp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PvActivityFollowUpData
     */
    public $followUp;
    /**
     * The fieldValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPvFieldValueData
     */
    public $fieldValues;
    /**
     * Constructor method for ActivityCreate
     * @uses ActivityCreate::setConnectToActivityId()
     * @uses ActivityCreate::setCredentials()
     * @uses ActivityCreate::setSettings()
     * @uses ActivityCreate::setFollowUp()
     * @uses ActivityCreate::setFieldValues()
     * @param string $connectToActivityId
     * @param \StructType\ApiCredentials $credentials
     * @param \StructType\PvActivitySettingsData $settings
     * @param \StructType\PvActivityFollowUpData $followUp
     * @param \ArrayType\ArrayOfPvFieldValueData $fieldValues
     */
    public function __construct($connectToActivityId = null, \StructType\ApiCredentials $credentials = null, \StructType\PvActivitySettingsData $settings = null, \StructType\PvActivityFollowUpData $followUp = null, \ArrayType\ArrayOfPvFieldValueData $fieldValues = null)
    {
        $this
            ->setConnectToActivityId($connectToActivityId)
            ->setCredentials($credentials)
            ->setSettings($settings)
            ->setFollowUp($followUp)
            ->setFieldValues($fieldValues);
    }
    /**
     * Get connectToActivityId value
     * @return string
     */
    public function getConnectToActivityId()
    {
        return $this->connectToActivityId;
    }
    /**
     * Set connectToActivityId value
     * @param string $connectToActivityId
     * @return \StructType\ActivityCreate
     */
    public function setConnectToActivityId($connectToActivityId = null)
    {
        // validation for constraint: string
        if (!is_null($connectToActivityId) && !is_string($connectToActivityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($connectToActivityId, true), gettype($connectToActivityId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($connectToActivityId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $connectToActivityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($connectToActivityId, true)), __LINE__);
        }
        $this->connectToActivityId = $connectToActivityId;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\ActivityCreate
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Get settings value
     * @return \StructType\PvActivitySettingsData|null
     */
    public function getSettings()
    {
        return $this->settings;
    }
    /**
     * Set settings value
     * @param \StructType\PvActivitySettingsData $settings
     * @return \StructType\ActivityCreate
     */
    public function setSettings(\StructType\PvActivitySettingsData $settings = null)
    {
        $this->settings = $settings;
        return $this;
    }
    /**
     * Get followUp value
     * @return \StructType\PvActivityFollowUpData|null
     */
    public function getFollowUp()
    {
        return $this->followUp;
    }
    /**
     * Set followUp value
     * @param \StructType\PvActivityFollowUpData $followUp
     * @return \StructType\ActivityCreate
     */
    public function setFollowUp(\StructType\PvActivityFollowUpData $followUp = null)
    {
        $this->followUp = $followUp;
        return $this;
    }
    /**
     * Get fieldValues value
     * @return \ArrayType\ArrayOfPvFieldValueData|null
     */
    public function getFieldValues()
    {
        return $this->fieldValues;
    }
    /**
     * Set fieldValues value
     * @param \ArrayType\ArrayOfPvFieldValueData $fieldValues
     * @return \StructType\ActivityCreate
     */
    public function setFieldValues(\ArrayType\ArrayOfPvFieldValueData $fieldValues = null)
    {
        $this->fieldValues = $fieldValues;
        return $this;
    }
}
