<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityAddLine StructType
 * @subpackage Structs
 */
class ActivityAddLine extends AbstractStructBase
{
    /**
     * The activityId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $activityId;
    /**
     * The entityTypeId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $entityTypeId;
    /**
     * The datastoreId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $datastoreId;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * The fieldValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPvFieldValueData
     */
    public $fieldValues;
    /**
     * Constructor method for ActivityAddLine
     * @uses ActivityAddLine::setActivityId()
     * @uses ActivityAddLine::setEntityTypeId()
     * @uses ActivityAddLine::setDatastoreId()
     * @uses ActivityAddLine::setCredentials()
     * @uses ActivityAddLine::setFieldValues()
     * @param string $activityId
     * @param string $entityTypeId
     * @param string $datastoreId
     * @param \StructType\ApiCredentials $credentials
     * @param \ArrayType\ArrayOfPvFieldValueData $fieldValues
     */
    public function __construct($activityId = null, $entityTypeId = null, $datastoreId = null, \StructType\ApiCredentials $credentials = null, \ArrayType\ArrayOfPvFieldValueData $fieldValues = null)
    {
        $this
            ->setActivityId($activityId)
            ->setEntityTypeId($entityTypeId)
            ->setDatastoreId($datastoreId)
            ->setCredentials($credentials)
            ->setFieldValues($fieldValues);
    }
    /**
     * Get activityId value
     * @return string
     */
    public function getActivityId()
    {
        return $this->activityId;
    }
    /**
     * Set activityId value
     * @param string $activityId
     * @return \StructType\ActivityAddLine
     */
    public function setActivityId($activityId = null)
    {
        // validation for constraint: string
        if (!is_null($activityId) && !is_string($activityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityId, true), gettype($activityId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($activityId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $activityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($activityId, true)), __LINE__);
        }
        $this->activityId = $activityId;
        return $this;
    }
    /**
     * Get entityTypeId value
     * @return string
     */
    public function getEntityTypeId()
    {
        return $this->entityTypeId;
    }
    /**
     * Set entityTypeId value
     * @param string $entityTypeId
     * @return \StructType\ActivityAddLine
     */
    public function setEntityTypeId($entityTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($entityTypeId) && !is_string($entityTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityTypeId, true), gettype($entityTypeId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($entityTypeId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $entityTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($entityTypeId, true)), __LINE__);
        }
        $this->entityTypeId = $entityTypeId;
        return $this;
    }
    /**
     * Get datastoreId value
     * @return string
     */
    public function getDatastoreId()
    {
        return $this->datastoreId;
    }
    /**
     * Set datastoreId value
     * @param string $datastoreId
     * @return \StructType\ActivityAddLine
     */
    public function setDatastoreId($datastoreId = null)
    {
        // validation for constraint: string
        if (!is_null($datastoreId) && !is_string($datastoreId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datastoreId, true), gettype($datastoreId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($datastoreId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $datastoreId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($datastoreId, true)), __LINE__);
        }
        $this->datastoreId = $datastoreId;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\ActivityAddLine
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
    /**
     * Get fieldValues value
     * @return \ArrayType\ArrayOfPvFieldValueData|null
     */
    public function getFieldValues()
    {
        return $this->fieldValues;
    }
    /**
     * Set fieldValues value
     * @param \ArrayType\ArrayOfPvFieldValueData $fieldValues
     * @return \StructType\ActivityAddLine
     */
    public function setFieldValues(\ArrayType\ArrayOfPvFieldValueData $fieldValues = null)
    {
        $this->fieldValues = $fieldValues;
        return $this;
    }
}
