<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityAddInvolved StructType
 * @subpackage Structs
 */
class ActivityAddInvolved extends AbstractStructBase
{
    /**
     * The activityId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $activityId;
    /**
     * The involvedEntityTypeId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $involvedEntityTypeId;
    /**
     * The relationshipId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $relationshipId;
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApiCredentials
     */
    public $credentials;
    /**
     * Constructor method for ActivityAddInvolved
     * @uses ActivityAddInvolved::setActivityId()
     * @uses ActivityAddInvolved::setInvolvedEntityTypeId()
     * @uses ActivityAddInvolved::setRelationshipId()
     * @uses ActivityAddInvolved::setCredentials()
     * @param string $activityId
     * @param string $involvedEntityTypeId
     * @param string $relationshipId
     * @param \StructType\ApiCredentials $credentials
     */
    public function __construct($activityId = null, $involvedEntityTypeId = null, $relationshipId = null, \StructType\ApiCredentials $credentials = null)
    {
        $this
            ->setActivityId($activityId)
            ->setInvolvedEntityTypeId($involvedEntityTypeId)
            ->setRelationshipId($relationshipId)
            ->setCredentials($credentials);
    }
    /**
     * Get activityId value
     * @return string
     */
    public function getActivityId()
    {
        return $this->activityId;
    }
    /**
     * Set activityId value
     * @param string $activityId
     * @return \StructType\ActivityAddInvolved
     */
    public function setActivityId($activityId = null)
    {
        // validation for constraint: string
        if (!is_null($activityId) && !is_string($activityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityId, true), gettype($activityId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($activityId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $activityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($activityId, true)), __LINE__);
        }
        $this->activityId = $activityId;
        return $this;
    }
    /**
     * Get involvedEntityTypeId value
     * @return string
     */
    public function getInvolvedEntityTypeId()
    {
        return $this->involvedEntityTypeId;
    }
    /**
     * Set involvedEntityTypeId value
     * @param string $involvedEntityTypeId
     * @return \StructType\ActivityAddInvolved
     */
    public function setInvolvedEntityTypeId($involvedEntityTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($involvedEntityTypeId) && !is_string($involvedEntityTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($involvedEntityTypeId, true), gettype($involvedEntityTypeId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($involvedEntityTypeId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $involvedEntityTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($involvedEntityTypeId, true)), __LINE__);
        }
        $this->involvedEntityTypeId = $involvedEntityTypeId;
        return $this;
    }
    /**
     * Get relationshipId value
     * @return string
     */
    public function getRelationshipId()
    {
        return $this->relationshipId;
    }
    /**
     * Set relationshipId value
     * @param string $relationshipId
     * @return \StructType\ActivityAddInvolved
     */
    public function setRelationshipId($relationshipId = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipId) && !is_string($relationshipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationshipId, true), gettype($relationshipId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($relationshipId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $relationshipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($relationshipId, true)), __LINE__);
        }
        $this->relationshipId = $relationshipId;
        return $this;
    }
    /**
     * Get credentials value
     * @return \StructType\ApiCredentials|null
     */
    public function getCredentials()
    {
        return $this->credentials;
    }
    /**
     * Set credentials value
     * @param \StructType\ApiCredentials $credentials
     * @return \StructType\ActivityAddInvolved
     */
    public function setCredentials(\StructType\ApiCredentials $credentials = null)
    {
        $this->credentials = $credentials;
        return $this;
    }
}
