<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Workflow ServiceType
 * @subpackage Services
 */
class Workflow extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named WorkflowGet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WorkflowGet $parameters
     * @return \StructType\WorkflowGetResponse|bool
     */
    public function WorkflowGet(\StructType\WorkflowGet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->WorkflowGet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named WorkflowGetAll
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WorkflowGetAll $parameters
     * @return \StructType\WorkflowGetAllResponse|bool
     */
    public function WorkflowGetAll(\StructType\WorkflowGetAll $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->WorkflowGetAll($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named WorkflowStepGet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WorkflowStepGet $parameters
     * @return \StructType\WorkflowStepGetResponse|bool
     */
    public function WorkflowStepGet(\StructType\WorkflowStepGet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->WorkflowStepGet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named WorkflowStepGetAll
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WorkflowStepGetAll $parameters
     * @return \StructType\WorkflowStepGetAllResponse|bool
     */
    public function WorkflowStepGetAll(\StructType\WorkflowStepGetAll $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->WorkflowStepGetAll($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named WorkflowGetQueues
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WorkflowGetQueues $parameters
     * @return \StructType\WorkflowGetQueuesResponse|bool
     */
    public function WorkflowGetQueues(\StructType\WorkflowGetQueues $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->WorkflowGetQueues($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\WorkflowGetAllResponse|\StructType\WorkflowGetQueuesResponse|\StructType\WorkflowGetResponse|\StructType\WorkflowStepGetAllResponse|\StructType\WorkflowStepGetResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
