<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Users ServiceType
 * @subpackage Services
 */
class Users extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UsersGetActive
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UsersGetActive $parameters
     * @return \StructType\UsersGetActiveResponse|bool
     */
    public function UsersGetActive(\StructType\UsersGetActive $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UsersGetActive($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UsersGetRoles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UsersGetRoles $parameters
     * @return \StructType\UsersGetRolesResponse|bool
     */
    public function UsersGetRoles(\StructType\UsersGetRoles $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UsersGetRoles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UsersGetLanguage
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UsersGetLanguage $parameters
     * @return \StructType\UsersGetLanguageResponse|bool
     */
    public function UsersGetLanguage(\StructType\UsersGetLanguage $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UsersGetLanguage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UsersSetLanguage
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UsersSetLanguage $parameters
     * @return \StructType\UsersSetLanguageResponse|bool
     */
    public function UsersSetLanguage(\StructType\UsersSetLanguage $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UsersSetLanguage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UsersGetActiveResponse|\StructType\UsersGetLanguageResponse|\StructType\UsersGetRolesResponse|\StructType\UsersSetLanguageResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
