<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for User ServiceType
 * @subpackage Services
 */
class User extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UserAddRoles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UserAddRoles $parameters
     * @return \StructType\UserAddRolesResponse|bool
     */
    public function UserAddRoles(\StructType\UserAddRoles $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UserAddRoles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserGetNavigationItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UserGetNavigationItems $parameters
     * @return \StructType\UserGetNavigationItemsResponse|bool
     */
    public function UserGetNavigationItems(\StructType\UserGetNavigationItems $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UserGetNavigationItems($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserGetCreateMenuItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UserGetCreateMenuItems $parameters
     * @return \StructType\UserGetCreateMenuItemsResponse|bool
     */
    public function UserGetCreateMenuItems(\StructType\UserGetCreateMenuItems $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UserGetCreateMenuItems($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserGetViewDefinitions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UserGetViewDefinitions $parameters
     * @return \StructType\UserGetViewDefinitionsResponse|bool
     */
    public function UserGetViewDefinitions(\StructType\UserGetViewDefinitions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UserGetViewDefinitions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UserGetDatabases
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UserGetDatabases $parameters
     * @return \StructType\UserGetDatabasesResponse|bool
     */
    public function UserGetDatabases(\StructType\UserGetDatabases $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UserGetDatabases($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UserAddRolesResponse|\StructType\UserGetCreateMenuItemsResponse|\StructType\UserGetDatabasesResponse|\StructType\UserGetNavigationItemsResponse|\StructType\UserGetViewDefinitionsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
