<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Subscription ServiceType
 * @subpackage Services
 */
class Subscription extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SubscriptionCreate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SubscriptionCreate $parameters
     * @return \StructType\SubscriptionCreateResponse|bool
     */
    public function SubscriptionCreate(\StructType\SubscriptionCreate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SubscriptionCreate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SubscriptionUpdate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SubscriptionUpdate $parameters
     * @return \StructType\SubscriptionUpdateResponse|bool
     */
    public function SubscriptionUpdate(\StructType\SubscriptionUpdate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SubscriptionUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SubscriptionAddProductLine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SubscriptionAddProductLine $parameters
     * @return \StructType\SubscriptionAddProductLineResponse|bool
     */
    public function SubscriptionAddProductLine(\StructType\SubscriptionAddProductLine $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SubscriptionAddProductLine($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SubscriptionAddProductLineResponse|\StructType\SubscriptionCreateResponse|\StructType\SubscriptionUpdateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
