<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Relationship ServiceType
 * @subpackage Services
 */
class Relationship extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RelationshipFieldGetLabels
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationshipFieldGetLabels $parameters
     * @return \StructType\RelationshipFieldGetLabelsResponse|bool
     */
    public function RelationshipFieldGetLabels(\StructType\RelationshipFieldGetLabels $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationshipFieldGetLabels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationshipCreate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationshipCreate $parameters
     * @return \StructType\RelationshipCreateResponse|bool
     */
    public function RelationshipCreate(\StructType\RelationshipCreate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationshipCreate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationshipUpdate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationshipUpdate $parameters
     * @return \StructType\RelationshipUpdateResponse|bool
     */
    public function RelationshipUpdate(\StructType\RelationshipUpdate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationshipUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationshipAddMark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationshipAddMark $parameters
     * @return \StructType\RelationshipAddMarkResponse|bool
     */
    public function RelationshipAddMark(\StructType\RelationshipAddMark $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationshipAddMark($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationshipAddMarkV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationshipAddMarkV2 $parameters
     * @return \StructType\RelationshipAddMarkV2Response|bool
     */
    public function RelationshipAddMarkV2(\StructType\RelationshipAddMarkV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationshipAddMarkV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationshipRemoveMark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationshipRemoveMark $parameters
     * @return \StructType\RelationshipRemoveMarkResponse|bool
     */
    public function RelationshipRemoveMark(\StructType\RelationshipRemoveMark $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationshipRemoveMark($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationshipAddFieldLabel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationshipAddFieldLabel $parameters
     * @return \StructType\RelationshipAddFieldLabelResponse|bool
     */
    public function RelationshipAddFieldLabel(\StructType\RelationshipAddFieldLabel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationshipAddFieldLabel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationshipAddLine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationshipAddLine $parameters
     * @return \StructType\RelationshipAddLineResponse|bool
     */
    public function RelationshipAddLine(\StructType\RelationshipAddLine $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationshipAddLine($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationshipAddLineV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationshipAddLineV2 $parameters
     * @return \StructType\RelationshipAddLineV2Response|bool
     */
    public function RelationshipAddLineV2(\StructType\RelationshipAddLineV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationshipAddLineV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationshipViewGetData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationshipViewGetData $parameters
     * @return \StructType\RelationshipViewGetDataResponse|bool
     */
    public function RelationshipViewGetData(\StructType\RelationshipViewGetData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationshipViewGetData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationshipGetFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationshipGetFields $parameters
     * @return \StructType\RelationshipGetFieldsResponse|bool
     */
    public function RelationshipGetFields(\StructType\RelationshipGetFields $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationshipGetFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationshipExists
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationshipExists $parameters
     * @return \StructType\RelationshipExistsResponse|bool
     */
    public function RelationshipExists(\StructType\RelationshipExists $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationshipExists($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationshipGetAll
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationshipGetAll $parameters
     * @return \StructType\RelationshipGetAllResponse|bool
     */
    public function RelationshipGetAll(\StructType\RelationshipGetAll $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationshipGetAll($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationshipGetModified
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationshipGetModified $parameters
     * @return \StructType\RelationshipGetModifiedResponse|bool
     */
    public function RelationshipGetModified(\StructType\RelationshipGetModified $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationshipGetModified($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationshipGet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationshipGet $parameters
     * @return \StructType\RelationshipGetResponse|bool
     */
    public function RelationshipGet(\StructType\RelationshipGet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationshipGet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationshipGetEmployees
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationshipGetEmployees $parameters
     * @return \StructType\RelationshipGetEmployeesResponse|bool
     */
    public function RelationshipGetEmployees(\StructType\RelationshipGetEmployees $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationshipGetEmployees($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationshipGetEmployeesModified
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationshipGetEmployeesModified $parameters
     * @return \StructType\RelationshipGetEmployeesModifiedResponse|bool
     */
    public function RelationshipGetEmployeesModified(\StructType\RelationshipGetEmployeesModified $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationshipGetEmployeesModified($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationshipSearchByName
     * Meta information extracted from the WSDL
     * - documentation: This method is deprecated, use RelationshipSearchByName_V2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationshipSearchByName $parameters
     * @return \StructType\RelationshipSearchByNameResponse|bool
     */
    public function RelationshipSearchByName(\StructType\RelationshipSearchByName $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationshipSearchByName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationshipSearchByName_V2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationshipSearchByName_V2 $parameters
     * @return \StructType\RelationshipSearchByName_V2Response|bool
     */
    public function RelationshipSearchByName_V2(\StructType\RelationshipSearchByName_V2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationshipSearchByName_V2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationshipSearchByEmail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationshipSearchByEmail $parameters
     * @return \StructType\RelationshipSearchByEmailResponse|bool
     */
    public function RelationshipSearchByEmail(\StructType\RelationshipSearchByEmail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationshipSearchByEmail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationshipSearchByField
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationshipSearchByField $parameters
     * @return \StructType\RelationshipSearchByFieldResponse|bool
     */
    public function RelationshipSearchByField(\StructType\RelationshipSearchByField $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationshipSearchByField($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationshipSearchByMark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationshipSearchByMark $parameters
     * @return \StructType\RelationshipSearchByMarkResponse|bool
     */
    public function RelationshipSearchByMark(\StructType\RelationshipSearchByMark $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationshipSearchByMark($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationshipSearchByMarkAndDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationshipSearchByMarkAndDate $parameters
     * @return \StructType\RelationshipSearchByMarkAndDateResponse|bool
     */
    public function RelationshipSearchByMarkAndDate(\StructType\RelationshipSearchByMarkAndDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationshipSearchByMarkAndDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationshipGetMarks
     * Meta information extracted from the WSDL
     * - documentation: Get mark and relationship data
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationshipGetMarks $parameters
     * @return \StructType\RelationshipGetMarksResponse|bool
     */
    public function RelationshipGetMarks(\StructType\RelationshipGetMarks $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationshipGetMarks($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationshipGetMarksCompact
     * Meta information extracted from the WSDL
     * - documentation: Get mark data without relationship info
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationshipGetMarksCompact $parameters
     * @return \StructType\RelationshipGetMarksCompactResponse|bool
     */
    public function RelationshipGetMarksCompact(\StructType\RelationshipGetMarksCompact $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationshipGetMarksCompact($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RelationshipGetLines
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RelationshipGetLines $parameters
     * @return \StructType\RelationshipGetLinesResponse|bool
     */
    public function RelationshipGetLines(\StructType\RelationshipGetLines $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RelationshipGetLines($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RelationshipAddFieldLabelResponse|\StructType\RelationshipAddLineResponse|\StructType\RelationshipAddLineV2Response|\StructType\RelationshipAddMarkResponse|\StructType\RelationshipAddMarkV2Response|\StructType\RelationshipCreateResponse|\StructType\RelationshipExistsResponse|\StructType\RelationshipFieldGetLabelsResponse|\StructType\RelationshipGetAllResponse|\StructType\RelationshipGetEmployeesModifiedResponse|\StructType\RelationshipGetEmployeesResponse|\StructType\RelationshipGetFieldsResponse|\StructType\RelationshipGetLinesResponse|\StructType\RelationshipGetMarksCompactResponse|\StructType\RelationshipGetMarksResponse|\StructType\RelationshipGetModifiedResponse|\StructType\RelationshipGetResponse|\StructType\RelationshipRemoveMarkResponse|\StructType\RelationshipSearchByEmailResponse|\StructType\RelationshipSearchByFieldResponse|\StructType\RelationshipSearchByMarkAndDateResponse|\StructType\RelationshipSearchByMarkResponse|\StructType\RelationshipSearchByNameResponse|\StructType\RelationshipSearchByName_V2Response|\StructType\RelationshipUpdateResponse|\StructType\RelationshipViewGetDataResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
