<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Product ServiceType
 * @subpackage Services
 */
class Product extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ProductGroupCreate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProductGroupCreate $parameters
     * @return \StructType\ProductGroupCreateResponse|bool
     */
    public function ProductGroupCreate(\StructType\ProductGroupCreate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProductGroupCreate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProductGroupUpdate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProductGroupUpdate $parameters
     * @return \StructType\ProductGroupUpdateResponse|bool
     */
    public function ProductGroupUpdate(\StructType\ProductGroupUpdate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProductGroupUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProductCreate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProductCreate $parameters
     * @return \StructType\ProductCreateResponse|bool
     */
    public function ProductCreate(\StructType\ProductCreate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProductCreate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProductCreate_V2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProductCreate_V2 $parameters
     * @return \StructType\ProductCreate_V2Response|bool
     */
    public function ProductCreate_V2(\StructType\ProductCreate_V2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProductCreate_V2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProductUpdate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProductUpdate $parameters
     * @return \StructType\ProductUpdateResponse|bool
     */
    public function ProductUpdate(\StructType\ProductUpdate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProductUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProductUpdate_V2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProductUpdate_V2 $parameters
     * @return \StructType\ProductUpdate_V2Response|bool
     */
    public function ProductUpdate_V2(\StructType\ProductUpdate_V2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProductUpdate_V2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProductGetVatCodes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProductGetVatCodes $parameters
     * @return \StructType\ProductGetVatCodesResponse|bool
     */
    public function ProductGetVatCodes(\StructType\ProductGetVatCodes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProductGetVatCodes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProductGetUnits
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProductGetUnits $parameters
     * @return \StructType\ProductGetUnitsResponse|bool
     */
    public function ProductGetUnits(\StructType\ProductGetUnits $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProductGetUnits($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProductGetUnits_V2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProductGetUnits_V2 $parameters
     * @return \StructType\ProductGetUnits_V2Response|bool
     */
    public function ProductGetUnits_V2(\StructType\ProductGetUnits_V2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProductGetUnits_V2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProductGetTypes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProductGetTypes $parameters
     * @return \StructType\ProductGetTypesResponse|bool
     */
    public function ProductGetTypes(\StructType\ProductGetTypes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProductGetTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProductGroupExists
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProductGroupExists $parameters
     * @return \StructType\ProductGroupExistsResponse|bool
     */
    public function ProductGroupExists(\StructType\ProductGroupExists $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProductGroupExists($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProductGroupGet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProductGroupGet $parameters
     * @return \StructType\ProductGroupGetResponse|bool
     */
    public function ProductGroupGet(\StructType\ProductGroupGet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProductGroupGet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProductGroupGetAll
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProductGroupGetAll $parameters
     * @return \StructType\ProductGroupGetAllResponse|bool
     */
    public function ProductGroupGetAll(\StructType\ProductGroupGetAll $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProductGroupGetAll($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProductExists
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProductExists $parameters
     * @return \StructType\ProductExistsResponse|bool
     */
    public function ProductExists(\StructType\ProductExists $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProductExists($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProductSearchByFieldExact
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProductSearchByFieldExact $parameters
     * @return \StructType\ProductSearchByFieldExactResponse|bool
     */
    public function ProductSearchByFieldExact(\StructType\ProductSearchByFieldExact $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProductSearchByFieldExact($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProductGet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProductGet $parameters
     * @return \StructType\ProductGetResponse|bool
     */
    public function ProductGet(\StructType\ProductGet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProductGet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProductGet_V2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProductGet_V2 $parameters
     * @return \StructType\ProductGet_V2Response|bool
     */
    public function ProductGet_V2(\StructType\ProductGet_V2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProductGet_V2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProductGetAll
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProductGetAll $parameters
     * @return \StructType\ProductGetAllResponse|bool
     */
    public function ProductGetAll(\StructType\ProductGetAll $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProductGetAll($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProductGetAll_V2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProductGetAll_V2 $parameters
     * @return \StructType\ProductGetAll_V2Response|bool
     */
    public function ProductGetAll_V2(\StructType\ProductGetAll_V2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProductGetAll_V2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProductGetAllByGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProductGetAllByGroup $parameters
     * @return \StructType\ProductGetAllByGroupResponse|bool
     */
    public function ProductGetAllByGroup(\StructType\ProductGetAllByGroup $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProductGetAllByGroup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProductGetAllByGroup_V2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProductGetAllByGroup_V2 $parameters
     * @return \StructType\ProductGetAllByGroup_V2Response|bool
     */
    public function ProductGetAllByGroup_V2(\StructType\ProductGetAllByGroup_V2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProductGetAllByGroup_V2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProductLineGet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProductLineGet $parameters
     * @return \StructType\ProductLineGetResponse|bool
     */
    public function ProductLineGet(\StructType\ProductLineGet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProductLineGet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ProductCreateResponse|\StructType\ProductCreate_V2Response|\StructType\ProductExistsResponse|\StructType\ProductGetAllByGroupResponse|\StructType\ProductGetAllByGroup_V2Response|\StructType\ProductGetAllResponse|\StructType\ProductGetAll_V2Response|\StructType\ProductGetResponse|\StructType\ProductGetTypesResponse|\StructType\ProductGetUnitsResponse|\StructType\ProductGetUnits_V2Response|\StructType\ProductGetVatCodesResponse|\StructType\ProductGet_V2Response|\StructType\ProductGroupCreateResponse|\StructType\ProductGroupExistsResponse|\StructType\ProductGroupGetAllResponse|\StructType\ProductGroupGetResponse|\StructType\ProductGroupUpdateResponse|\StructType\ProductLineGetResponse|\StructType\ProductSearchByFieldExactResponse|\StructType\ProductUpdateResponse|\StructType\ProductUpdate_V2Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
