<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Parameter ServiceType
 * @subpackage Services
 */
class Parameter extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ParameterGet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ParameterGet $parameters
     * @return \StructType\ParameterGetResponse|bool
     */
    public function ParameterGet(\StructType\ParameterGet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ParameterGet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ParameterGetResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
