<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Note ServiceType
 * @subpackage Services
 */
class Note extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named NoteGet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NoteGet $parameters
     * @return \StructType\NoteGetResponse|bool
     */
    public function NoteGet(\StructType\NoteGet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->NoteGet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named NoteUpdate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NoteUpdate $parameters
     * @return \StructType\NoteUpdateResponse|bool
     */
    public function NoteUpdate(\StructType\NoteUpdate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->NoteUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named NoteExists
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NoteExists $parameters
     * @return \StructType\NoteExistsResponse|bool
     */
    public function NoteExists(\StructType\NoteExists $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->NoteExists($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\NoteExistsResponse|\StructType\NoteGetResponse|\StructType\NoteUpdateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
