<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Mark ServiceType
 * @subpackage Services
 */
class Mark extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named MarkAdd
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MarkAdd $parameters
     * @return \StructType\MarkAddResponse|bool
     */
    public function MarkAdd(\StructType\MarkAdd $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MarkAdd($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MarkGetAll
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MarkGetAll $parameters
     * @return \StructType\MarkGetAllResponse|bool
     */
    public function MarkGetAll(\StructType\MarkGetAll $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MarkGetAll($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MarkGetAllV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MarkGetAllV2 $parameters
     * @return \StructType\MarkGetAllV2Response|bool
     */
    public function MarkGetAllV2(\StructType\MarkGetAllV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MarkGetAllV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MarkAddResponse|\StructType\MarkGetAllResponse|\StructType\MarkGetAllV2Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
