<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Has ServiceType
 * @subpackage Services
 */
class Has extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named HasAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HasAccess $parameters
     * @return \StructType\HasAccessResponse|bool
     */
    public function HasAccess(\StructType\HasAccess $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->HasAccess($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\HasAccessResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
