<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Field ServiceType
 * @subpackage Services
 */
class Field extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named FieldGet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FieldGet $parameters
     * @return \StructType\FieldGetResponse|bool
     */
    public function FieldGet(\StructType\FieldGet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FieldGet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\FieldGetResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
