<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Enumeration ServiceType
 * @subpackage Services
 */
class Enumeration extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EnumerationGetItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnumerationGetItems $parameters
     * @return \StructType\EnumerationGetItemsResponse|bool
     */
    public function EnumerationGetItems(\StructType\EnumerationGetItems $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EnumerationGetItems($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EnumerationGetItemsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
