<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Datastore ServiceType
 * @subpackage Services
 */
class Datastore extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DatastoreCreateItem
     * Meta information extracted from the WSDL
     * - documentation: This method is deprecated, use DatastoreCreateItem_V2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DatastoreCreateItem $parameters
     * @return \StructType\DatastoreCreateItemResponse|bool
     */
    public function DatastoreCreateItem(\StructType\DatastoreCreateItem $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DatastoreCreateItem($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DatastoreCreateItem_V2
     * Meta information extracted from the WSDL
     * - documentation: This method is deprecated, use DatastoreCreateItem_V3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DatastoreCreateItem_V2 $parameters
     * @return \StructType\DatastoreCreateItem_V2Response|bool
     */
    public function DatastoreCreateItem_V2(\StructType\DatastoreCreateItem_V2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DatastoreCreateItem_V2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DatastoreCreateItem_V3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DatastoreCreateItem_V3 $parameters
     * @return \StructType\DatastoreCreateItem_V3Response|bool
     */
    public function DatastoreCreateItem_V3(\StructType\DatastoreCreateItem_V3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DatastoreCreateItem_V3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DatastoreUpdateItem
     * Meta information extracted from the WSDL
     * - documentation: This method is deprecated, use DatastoreUpdateItem_V2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DatastoreUpdateItem $parameters
     * @return \StructType\DatastoreUpdateItemResponse|bool
     */
    public function DatastoreUpdateItem(\StructType\DatastoreUpdateItem $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DatastoreUpdateItem($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DatastoreUpdateItem_V2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DatastoreUpdateItem_V2 $parameters
     * @return \StructType\DatastoreUpdateItem_V2Response|bool
     */
    public function DatastoreUpdateItem_V2(\StructType\DatastoreUpdateItem_V2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DatastoreUpdateItem_V2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DatastoreDeleteItem
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DatastoreDeleteItem $parameters
     * @return \StructType\DatastoreDeleteItemResponse|bool
     */
    public function DatastoreDeleteItem(\StructType\DatastoreDeleteItem $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DatastoreDeleteItem($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DatastoreGetItems
     * Meta information extracted from the WSDL
     * - documentation: This method is deprecated, use DatastoreGetItems_V2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DatastoreGetItems $parameters
     * @return \StructType\DatastoreGetItemsResponse|bool
     */
    public function DatastoreGetItems(\StructType\DatastoreGetItems $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DatastoreGetItems($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DatastoreGetItems_V2
     * Meta information extracted from the WSDL
     * - documentation: This method is deprecated, use DatastoreGetItems_V3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DatastoreGetItems_V2 $parameters
     * @return \StructType\DatastoreGetItems_V2Response|bool
     */
    public function DatastoreGetItems_V2(\StructType\DatastoreGetItems_V2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DatastoreGetItems_V2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DatastoreGetItems_V3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DatastoreGetItems_V3 $parameters
     * @return \StructType\DatastoreGetItems_V3Response|bool
     */
    public function DatastoreGetItems_V3(\StructType\DatastoreGetItems_V3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DatastoreGetItems_V3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DatastoreGetWithParentItems
     * Meta information extracted from the WSDL
     * - documentation: This method is deprecated, use DatastoreGetWithParentItems_V2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DatastoreGetWithParentItems $parameters
     * @return \StructType\DatastoreGetWithParentItemsResponse|bool
     */
    public function DatastoreGetWithParentItems(\StructType\DatastoreGetWithParentItems $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DatastoreGetWithParentItems($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DatastoreGetWithParentItems_V2
     * Meta information extracted from the WSDL
     * - documentation: Returns a list of datastore items with parentId's. ParentId will be NULL if no parent datastore is set
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DatastoreGetWithParentItems_V2 $parameters
     * @return \StructType\DatastoreGetWithParentItems_V2Response|bool
     */
    public function DatastoreGetWithParentItems_V2(\StructType\DatastoreGetWithParentItems_V2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DatastoreGetWithParentItems_V2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DatastoreGetCountries
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DatastoreGetCountries $parameters
     * @return \StructType\DatastoreGetCountriesResponse|bool
     */
    public function DatastoreGetCountries(\StructType\DatastoreGetCountries $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DatastoreGetCountries($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DatastoreGetSbiCodes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DatastoreGetSbiCodes $parameters
     * @return \StructType\DatastoreGetSbiCodesResponse|bool
     */
    public function DatastoreGetSbiCodes(\StructType\DatastoreGetSbiCodes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DatastoreGetSbiCodes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DatastoreCreateItemResponse|\StructType\DatastoreCreateItem_V2Response|\StructType\DatastoreCreateItem_V3Response|\StructType\DatastoreDeleteItemResponse|\StructType\DatastoreGetCountriesResponse|\StructType\DatastoreGetItemsResponse|\StructType\DatastoreGetItems_V2Response|\StructType\DatastoreGetItems_V3Response|\StructType\DatastoreGetSbiCodesResponse|\StructType\DatastoreGetWithParentItemsResponse|\StructType\DatastoreGetWithParentItems_V2Response|\StructType\DatastoreUpdateItemResponse|\StructType\DatastoreUpdateItem_V2Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
