<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Attachment ServiceType
 * @subpackage Services
 */
class Attachment extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AttachmentGetLabels
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AttachmentGetLabels $parameters
     * @return \StructType\AttachmentGetLabelsResponse|bool
     */
    public function AttachmentGetLabels(\StructType\AttachmentGetLabels $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AttachmentGetLabels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AttachmentUpdate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AttachmentUpdate $parameters
     * @return \StructType\AttachmentUpdateResponse|bool
     */
    public function AttachmentUpdate(\StructType\AttachmentUpdate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AttachmentUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AttachmentAddLabel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AttachmentAddLabel $parameters
     * @return \StructType\AttachmentAddLabelResponse|bool
     */
    public function AttachmentAddLabel(\StructType\AttachmentAddLabel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AttachmentAddLabel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AttachmentExists
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AttachmentExists $parameters
     * @return \StructType\AttachmentExistsResponse|bool
     */
    public function AttachmentExists(\StructType\AttachmentExists $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AttachmentExists($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AttachmentGet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AttachmentGet $parameters
     * @return \StructType\AttachmentGetResponse|bool
     */
    public function AttachmentGet(\StructType\AttachmentGet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AttachmentGet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AttachmentGetGoogleDocsUrl
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AttachmentGetGoogleDocsUrl $parameters
     * @return \StructType\AttachmentGetGoogleDocsUrlResponse|bool
     */
    public function AttachmentGetGoogleDocsUrl(\StructType\AttachmentGetGoogleDocsUrl $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AttachmentGetGoogleDocsUrl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AttachmentAddLabelResponse|\StructType\AttachmentExistsResponse|\StructType\AttachmentGetGoogleDocsUrlResponse|\StructType\AttachmentGetLabelsResponse|\StructType\AttachmentGetResponse|\StructType\AttachmentUpdateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
