<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Activity ServiceType
 * @subpackage Services
 */
class Activity extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ActivityGetLabels
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivityGetLabels $parameters
     * @return \StructType\ActivityGetLabelsResponse|bool
     */
    public function ActivityGetLabels(\StructType\ActivityGetLabels $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActivityGetLabels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ActivityCreate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivityCreate $parameters
     * @return \StructType\ActivityCreateResponse|bool
     */
    public function ActivityCreate(\StructType\ActivityCreate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActivityCreate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ActivityUpdate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivityUpdate $parameters
     * @return \StructType\ActivityUpdateResponse|bool
     */
    public function ActivityUpdate(\StructType\ActivityUpdate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActivityUpdate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ActivityAddReference
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivityAddReference $parameters
     * @return \StructType\ActivityAddReferenceResponse|bool
     */
    public function ActivityAddReference(\StructType\ActivityAddReference $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActivityAddReference($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ActivityFlow
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivityFlow $parameters
     * @return \StructType\ActivityFlowResponse|bool
     */
    public function ActivityFlow(\StructType\ActivityFlow $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActivityFlow($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ActivityClose
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivityClose $parameters
     * @return \StructType\ActivityCloseResponse|bool
     */
    public function ActivityClose(\StructType\ActivityClose $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActivityClose($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ActivityAddAttachment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivityAddAttachment $parameters
     * @return \StructType\ActivityAddAttachmentResponse|bool
     */
    public function ActivityAddAttachment(\StructType\ActivityAddAttachment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActivityAddAttachment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ActivityDeleteAttachment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivityDeleteAttachment $parameters
     * @return \StructType\ActivityDeleteAttachmentResponse|bool
     */
    public function ActivityDeleteAttachment(\StructType\ActivityDeleteAttachment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActivityDeleteAttachment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ActivityAddNote
     * Meta information extracted from the WSDL
     * - documentation: this method is deprecated, use ActivityAddNote_V3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivityAddNote $parameters
     * @return \StructType\ActivityAddNoteResponse|bool
     */
    public function ActivityAddNote(\StructType\ActivityAddNote $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActivityAddNote($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ActivityAddNote_V2
     * Meta information extracted from the WSDL
     * - documentation: this method is deprecated, use ActivityAddNote_V3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivityAddNote_V2 $parameters
     * @return \StructType\ActivityAddNote_V2Response|bool
     */
    public function ActivityAddNote_V2(\StructType\ActivityAddNote_V2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActivityAddNote_V2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ActivityAddNote_V3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivityAddNote_V3 $parameters
     * @return \StructType\ActivityAddNote_V3Response|bool
     */
    public function ActivityAddNote_V3(\StructType\ActivityAddNote_V3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActivityAddNote_V3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ActivityAddInvolved
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivityAddInvolved $parameters
     * @return \StructType\ActivityAddInvolvedResponse|bool
     */
    public function ActivityAddInvolved(\StructType\ActivityAddInvolved $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActivityAddInvolved($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ActivityAddProductLine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivityAddProductLine $parameters
     * @return \StructType\ActivityAddProductLineResponse|bool
     */
    public function ActivityAddProductLine(\StructType\ActivityAddProductLine $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActivityAddProductLine($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ActivityDeleteProductLine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivityDeleteProductLine $parameters
     * @return \StructType\ActivityDeleteProductLineResponse|bool
     */
    public function ActivityDeleteProductLine(\StructType\ActivityDeleteProductLine $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActivityDeleteProductLine($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ActivityDeleteProductLines
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivityDeleteProductLines $parameters
     * @return \StructType\ActivityDeleteProductLinesResponse|bool
     */
    public function ActivityDeleteProductLines(\StructType\ActivityDeleteProductLines $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActivityDeleteProductLines($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ActivityAddParameters
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivityAddParameters $parameters
     * @return \StructType\ActivityAddParametersResponse|bool
     */
    public function ActivityAddParameters(\StructType\ActivityAddParameters $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActivityAddParameters($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ActivityAddLine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivityAddLine $parameters
     * @return \StructType\ActivityAddLineResponse|bool
     */
    public function ActivityAddLine(\StructType\ActivityAddLine $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActivityAddLine($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ActivityAddLineV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivityAddLineV2 $parameters
     * @return \StructType\ActivityAddLineV2Response|bool
     */
    public function ActivityAddLineV2(\StructType\ActivityAddLineV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActivityAddLineV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ActivityAddLabel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivityAddLabel $parameters
     * @return \StructType\ActivityAddLabelResponse|bool
     */
    public function ActivityAddLabel(\StructType\ActivityAddLabel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActivityAddLabel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ActivityAddFieldLabel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivityAddFieldLabel $parameters
     * @return \StructType\ActivityAddFieldLabelResponse|bool
     */
    public function ActivityAddFieldLabel(\StructType\ActivityAddFieldLabel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActivityAddFieldLabel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ActivityViewGetData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivityViewGetData $parameters
     * @return \StructType\ActivityViewGetDataResponse|bool
     */
    public function ActivityViewGetData(\StructType\ActivityViewGetData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActivityViewGetData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ActivityInvolvedEntityTypesGet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivityInvolvedEntityTypesGet $parameters
     * @return \StructType\ActivityInvolvedEntityTypesGetResponse|bool
     */
    public function ActivityInvolvedEntityTypesGet(\StructType\ActivityInvolvedEntityTypesGet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActivityInvolvedEntityTypesGet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ActivityGetFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivityGetFields $parameters
     * @return \StructType\ActivityGetFieldsResponse|bool
     */
    public function ActivityGetFields(\StructType\ActivityGetFields $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActivityGetFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ActivityExists
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivityExists $parameters
     * @return \StructType\ActivityExistsResponse|bool
     */
    public function ActivityExists(\StructType\ActivityExists $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActivityExists($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ActivityGet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivityGet $parameters
     * @return \StructType\ActivityGetResponse|bool
     */
    public function ActivityGet(\StructType\ActivityGet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActivityGet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ActivityGetConnectedActivities
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivityGetConnectedActivities $parameters
     * @return \StructType\ActivityGetConnectedActivitiesResponse|bool
     */
    public function ActivityGetConnectedActivities(\StructType\ActivityGetConnectedActivities $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActivityGetConnectedActivities($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ActivitySearchByField
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivitySearchByField $parameters
     * @return \StructType\ActivitySearchByFieldResponse|bool
     */
    public function ActivitySearchByField(\StructType\ActivitySearchByField $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActivitySearchByField($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ActivitySearchByFieldInPeriod
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivitySearchByFieldInPeriod $parameters
     * @return \StructType\ActivitySearchByFieldInPeriodResponse|bool
     */
    public function ActivitySearchByFieldInPeriod(\StructType\ActivitySearchByFieldInPeriod $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActivitySearchByFieldInPeriod($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ActivitySearchByFieldInPeriodExact
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivitySearchByFieldInPeriodExact $parameters
     * @return \StructType\ActivitySearchByFieldInPeriodExactResponse|bool
     */
    public function ActivitySearchByFieldInPeriodExact(\StructType\ActivitySearchByFieldInPeriodExact $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActivitySearchByFieldInPeriodExact($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ActivityGetAttachments
     * Meta information extracted from the WSDL
     * - documentation: This method is deprecated, use ActivityGetAttachments_V2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivityGetAttachments $parameters
     * @return \StructType\ActivityGetAttachmentsResponse|bool
     */
    public function ActivityGetAttachments(\StructType\ActivityGetAttachments $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActivityGetAttachments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ActivityGetAttachments_V2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivityGetAttachments_V2 $parameters
     * @return \StructType\ActivityGetAttachments_V2Response|bool
     */
    public function ActivityGetAttachments_V2(\StructType\ActivityGetAttachments_V2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActivityGetAttachments_V2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ActivityGetNotes
     * Meta information extracted from the WSDL
     * - documentation: This method is deprecated, use ActivityGetNotes_V2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivityGetNotes $parameters
     * @return \StructType\ActivityGetNotesResponse|bool
     */
    public function ActivityGetNotes(\StructType\ActivityGetNotes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActivityGetNotes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ActivityGetNotes_V2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivityGetNotes_V2 $parameters
     * @return \StructType\ActivityGetNotes_V2Response|bool
     */
    public function ActivityGetNotes_V2(\StructType\ActivityGetNotes_V2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActivityGetNotes_V2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ActivityGetInvolveds
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivityGetInvolveds $parameters
     * @return \StructType\ActivityGetInvolvedsResponse|bool
     */
    public function ActivityGetInvolveds(\StructType\ActivityGetInvolveds $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActivityGetInvolveds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ActivityGetProductLines
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivityGetProductLines $parameters
     * @return \StructType\ActivityGetProductLinesResponse|bool
     */
    public function ActivityGetProductLines(\StructType\ActivityGetProductLines $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActivityGetProductLines($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ActivityGetLines
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ActivityGetLines $parameters
     * @return \StructType\ActivityGetLinesResponse|bool
     */
    public function ActivityGetLines(\StructType\ActivityGetLines $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ActivityGetLines($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ActivityAddAttachmentResponse|\StructType\ActivityAddFieldLabelResponse|\StructType\ActivityAddInvolvedResponse|\StructType\ActivityAddLabelResponse|\StructType\ActivityAddLineResponse|\StructType\ActivityAddLineV2Response|\StructType\ActivityAddNoteResponse|\StructType\ActivityAddNote_V2Response|\StructType\ActivityAddNote_V3Response|\StructType\ActivityAddParametersResponse|\StructType\ActivityAddProductLineResponse|\StructType\ActivityAddReferenceResponse|\StructType\ActivityCloseResponse|\StructType\ActivityCreateResponse|\StructType\ActivityDeleteAttachmentResponse|\StructType\ActivityDeleteProductLineResponse|\StructType\ActivityDeleteProductLinesResponse|\StructType\ActivityExistsResponse|\StructType\ActivityFlowResponse|\StructType\ActivityGetAttachmentsResponse|\StructType\ActivityGetAttachments_V2Response|\StructType\ActivityGetConnectedActivitiesResponse|\StructType\ActivityGetFieldsResponse|\StructType\ActivityGetInvolvedsResponse|\StructType\ActivityGetLabelsResponse|\StructType\ActivityGetLinesResponse|\StructType\ActivityGetNotesResponse|\StructType\ActivityGetNotes_V2Response|\StructType\ActivityGetProductLinesResponse|\StructType\ActivityGetResponse|\StructType\ActivityInvolvedEntityTypesGetResponse|\StructType\ActivitySearchByFieldInPeriodExactResponse|\StructType\ActivitySearchByFieldInPeriodResponse|\StructType\ActivitySearchByFieldResponse|\StructType\ActivityUpdateResponse|\StructType\ActivityViewGetDataResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
