<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for SystemDatastoreType EnumType
 * @subpackage Enumerations
 */
class SystemDatastoreType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'LegalEntity'
     * @return string 'LegalEntity'
     */
    const VALUE_LEGAL_ENTITY = 'LegalEntity';
    /**
     * Constant for value 'ClassPersonnel'
     * @return string 'ClassPersonnel'
     */
    const VALUE_CLASS_PERSONNEL = 'ClassPersonnel';
    /**
     * Constant for value 'PaymentMethod'
     * @return string 'PaymentMethod'
     */
    const VALUE_PAYMENT_METHOD = 'PaymentMethod';
    /**
     * Constant for value 'Prolongation'
     * @return string 'Prolongation'
     */
    const VALUE_PROLONGATION = 'Prolongation';
    /**
     * Constant for value 'InvoiceMoment'
     * @return string 'InvoiceMoment'
     */
    const VALUE_INVOICE_MOMENT = 'InvoiceMoment';
    /**
     * Constant for value 'AuthorizationType'
     * @return string 'AuthorizationType'
     */
    const VALUE_AUTHORIZATION_TYPE = 'AuthorizationType';
    /**
     * Constant for value 'ReversalReason'
     * @return string 'ReversalReason'
     */
    const VALUE_REVERSAL_REASON = 'ReversalReason';
    /**
     * Constant for value 'BikeDepotBrand'
     * @return string 'BikeDepotBrand'
     */
    const VALUE_BIKE_DEPOT_BRAND = 'BikeDepotBrand';
    /**
     * Return allowed values
     * @uses self::VALUE_LEGAL_ENTITY
     * @uses self::VALUE_CLASS_PERSONNEL
     * @uses self::VALUE_PAYMENT_METHOD
     * @uses self::VALUE_PROLONGATION
     * @uses self::VALUE_INVOICE_MOMENT
     * @uses self::VALUE_AUTHORIZATION_TYPE
     * @uses self::VALUE_REVERSAL_REASON
     * @uses self::VALUE_BIKE_DEPOT_BRAND
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LEGAL_ENTITY,
            self::VALUE_CLASS_PERSONNEL,
            self::VALUE_PAYMENT_METHOD,
            self::VALUE_PROLONGATION,
            self::VALUE_INVOICE_MOMENT,
            self::VALUE_AUTHORIZATION_TYPE,
            self::VALUE_REVERSAL_REASON,
            self::VALUE_BIKE_DEPOT_BRAND,
        );
    }
}
