<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for DatabaseFieldType EnumType
 * @subpackage Enumerations
 */
class DatabaseFieldType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'UniqueIdentifier'
     * @return string 'UniqueIdentifier'
     */
    const VALUE_UNIQUE_IDENTIFIER = 'UniqueIdentifier';
    /**
     * Constant for value 'NVarChar'
     * @return string 'NVarChar'
     */
    const VALUE_NVAR_CHAR = 'NVarChar';
    /**
     * Constant for value 'Datetime'
     * @return string 'Datetime'
     */
    const VALUE_DATETIME = 'Datetime';
    /**
     * Constant for value 'Datetime2'
     * @return string 'Datetime2'
     */
    const VALUE_DATETIME_2_1 = 'Datetime2';
    /**
     * Constant for value 'Bit'
     * @return string 'Bit'
     */
    const VALUE_BIT = 'Bit';
    /**
     * Constant for value 'Float'
     * @return string 'Float'
     */
    const VALUE_FLOAT = 'Float';
    /**
     * Constant for value 'Int'
     * @return string 'Int'
     */
    const VALUE_INT = 'Int';
    /**
     * Constant for value 'Decimal'
     * @return string 'Decimal'
     */
    const VALUE_DECIMAL = 'Decimal';
    /**
     * Constant for value 'VarBinary'
     * @return string 'VarBinary'
     */
    const VALUE_VAR_BINARY = 'VarBinary';
    /**
     * Constant for value 'SmallInt'
     * @return string 'SmallInt'
     */
    const VALUE_SMALL_INT = 'SmallInt';
    /**
     * Constant for value 'Currency'
     * @return string 'Currency'
     */
    const VALUE_CURRENCY = 'Currency';
    /**
     * Constant for value 'BigInt'
     * @return string 'BigInt'
     */
    const VALUE_BIG_INT = 'BigInt';
    /**
     * Constant for value 'VarChar'
     * @return string 'VarChar'
     */
    const VALUE_VAR_CHAR = 'VarChar';
    /**
     * Constant for value 'Label'
     * @return string 'Label'
     */
    const VALUE_LABEL = 'Label';
    /**
     * Return allowed values
     * @uses self::VALUE_UNIQUE_IDENTIFIER
     * @uses self::VALUE_NVAR_CHAR
     * @uses self::VALUE_DATETIME_1
     * @uses self::VALUE_DATETIME_2_1
     * @uses self::VALUE_BIT
     * @uses self::VALUE_FLOAT
     * @uses self::VALUE_INT
     * @uses self::VALUE_DECIMAL
     * @uses self::VALUE_VAR_BINARY
     * @uses self::VALUE_SMALL_INT
     * @uses self::VALUE_CURRENCY
     * @uses self::VALUE_BIG_INT
     * @uses self::VALUE_VAR_CHAR
     * @uses self::VALUE_LABEL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNIQUE_IDENTIFIER,
            self::VALUE_NVAR_CHAR,
            self::VALUE_DATETIME_1,
            self::VALUE_DATETIME_2_1,
            self::VALUE_BIT,
            self::VALUE_FLOAT,
            self::VALUE_INT,
            self::VALUE_DECIMAL,
            self::VALUE_VAR_BINARY,
            self::VALUE_SMALL_INT,
            self::VALUE_CURRENCY,
            self::VALUE_BIG_INT,
            self::VALUE_VAR_CHAR,
            self::VALUE_LABEL,
        );
    }
}
