<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for AddressType EnumType
 * @subpackage Enumerations
 */
class AddressType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'PostAddress'
     * @return string 'PostAddress'
     */
    const VALUE_POST_ADDRESS = 'PostAddress';
    /**
     * Constant for value 'PrivateAddress'
     * @return string 'PrivateAddress'
     */
    const VALUE_PRIVATE_ADDRESS = 'PrivateAddress';
    /**
     * Constant for value 'PrivateDifferentAddress'
     * @return string 'PrivateDifferentAddress'
     */
    const VALUE_PRIVATE_DIFFERENT_ADDRESS = 'PrivateDifferentAddress';
    /**
     * Constant for value 'PostAddressOrganisation'
     * @return string 'PostAddressOrganisation'
     */
    const VALUE_POST_ADDRESS_ORGANISATION = 'PostAddressOrganisation';
    /**
     * Constant for value 'VisitAddress'
     * @return string 'VisitAddress'
     */
    const VALUE_VISIT_ADDRESS = 'VisitAddress';
    /**
     * Constant for value 'VisitAddressOrganization'
     * @return string 'VisitAddressOrganization'
     */
    const VALUE_VISIT_ADDRESS_ORGANIZATION = 'VisitAddressOrganization';
    /**
     * Constant for value 'BillingAddress'
     * @return string 'BillingAddress'
     */
    const VALUE_BILLING_ADDRESS = 'BillingAddress';
    /**
     * Constant for value 'BillingAddressOrganization'
     * @return string 'BillingAddressOrganization'
     */
    const VALUE_BILLING_ADDRESS_ORGANIZATION = 'BillingAddressOrganization';
    /**
     * Return allowed values
     * @uses self::VALUE_POST_ADDRESS
     * @uses self::VALUE_PRIVATE_ADDRESS
     * @uses self::VALUE_PRIVATE_DIFFERENT_ADDRESS
     * @uses self::VALUE_POST_ADDRESS_ORGANISATION
     * @uses self::VALUE_VISIT_ADDRESS
     * @uses self::VALUE_VISIT_ADDRESS_ORGANIZATION
     * @uses self::VALUE_BILLING_ADDRESS
     * @uses self::VALUE_BILLING_ADDRESS_ORGANIZATION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_POST_ADDRESS,
            self::VALUE_PRIVATE_ADDRESS,
            self::VALUE_PRIVATE_DIFFERENT_ADDRESS,
            self::VALUE_POST_ADDRESS_ORGANISATION,
            self::VALUE_VISIT_ADDRESS,
            self::VALUE_VISIT_ADDRESS_ORGANIZATION,
            self::VALUE_BILLING_ADDRESS,
            self::VALUE_BILLING_ADDRESS_ORGANIZATION,
        );
    }
}
