<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPvTranslationData ArrayType
 * @subpackage Arrays
 */
class ArrayOfPvTranslationData extends AbstractStructArrayBase
{
    /**
     * The PvTranslationData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PvTranslationData[]
     */
    public $PvTranslationData;
    /**
     * Constructor method for ArrayOfPvTranslationData
     * @uses ArrayOfPvTranslationData::setPvTranslationData()
     * @param \StructType\PvTranslationData[] $pvTranslationData
     */
    public function __construct(array $pvTranslationData = array())
    {
        $this
            ->setPvTranslationData($pvTranslationData);
    }
    /**
     * Get PvTranslationData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PvTranslationData[]|null
     */
    public function getPvTranslationData()
    {
        return isset($this->PvTranslationData) ? $this->PvTranslationData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPvTranslationData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPvTranslationData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePvTranslationDataForArrayConstraintsFromSetPvTranslationData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPvTranslationDataPvTranslationDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfPvTranslationDataPvTranslationDataItem instanceof \StructType\PvTranslationData) {
                $invalidValues[] = is_object($arrayOfPvTranslationDataPvTranslationDataItem) ? get_class($arrayOfPvTranslationDataPvTranslationDataItem) : sprintf('%s(%s)', gettype($arrayOfPvTranslationDataPvTranslationDataItem), var_export($arrayOfPvTranslationDataPvTranslationDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PvTranslationData property can only contain items of type \StructType\PvTranslationData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PvTranslationData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PvTranslationData[] $pvTranslationData
     * @return \ArrayType\ArrayOfPvTranslationData
     */
    public function setPvTranslationData(array $pvTranslationData = array())
    {
        // validation for constraint: array
        if ('' !== ($pvTranslationDataArrayErrorMessage = self::validatePvTranslationDataForArrayConstraintsFromSetPvTranslationData($pvTranslationData))) {
            throw new \InvalidArgumentException($pvTranslationDataArrayErrorMessage, __LINE__);
        }
        if (is_null($pvTranslationData) || (is_array($pvTranslationData) && empty($pvTranslationData))) {
            unset($this->PvTranslationData);
        } else {
            $this->PvTranslationData = $pvTranslationData;
        }
        return $this;
    }
    /**
     * Add item to PvTranslationData value
     * @throws \InvalidArgumentException
     * @param \StructType\PvTranslationData $item
     * @return \ArrayType\ArrayOfPvTranslationData
     */
    public function addToPvTranslationData(\StructType\PvTranslationData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PvTranslationData) {
            throw new \InvalidArgumentException(sprintf('The PvTranslationData property can only contain items of type \StructType\PvTranslationData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PvTranslationData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PvTranslationData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PvTranslationData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PvTranslationData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PvTranslationData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PvTranslationData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PvTranslationData
     */
    public function getAttributeName()
    {
        return 'PvTranslationData';
    }
}
