<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPvObjectRightData ArrayType
 * @subpackage Arrays
 */
class ArrayOfPvObjectRightData extends AbstractStructArrayBase
{
    /**
     * The PvObjectRightData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PvObjectRightData[]
     */
    public $PvObjectRightData;
    /**
     * Constructor method for ArrayOfPvObjectRightData
     * @uses ArrayOfPvObjectRightData::setPvObjectRightData()
     * @param \StructType\PvObjectRightData[] $pvObjectRightData
     */
    public function __construct(array $pvObjectRightData = array())
    {
        $this
            ->setPvObjectRightData($pvObjectRightData);
    }
    /**
     * Get PvObjectRightData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PvObjectRightData[]|null
     */
    public function getPvObjectRightData()
    {
        return isset($this->PvObjectRightData) ? $this->PvObjectRightData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPvObjectRightData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPvObjectRightData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePvObjectRightDataForArrayConstraintsFromSetPvObjectRightData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPvObjectRightDataPvObjectRightDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfPvObjectRightDataPvObjectRightDataItem instanceof \StructType\PvObjectRightData) {
                $invalidValues[] = is_object($arrayOfPvObjectRightDataPvObjectRightDataItem) ? get_class($arrayOfPvObjectRightDataPvObjectRightDataItem) : sprintf('%s(%s)', gettype($arrayOfPvObjectRightDataPvObjectRightDataItem), var_export($arrayOfPvObjectRightDataPvObjectRightDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PvObjectRightData property can only contain items of type \StructType\PvObjectRightData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PvObjectRightData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PvObjectRightData[] $pvObjectRightData
     * @return \ArrayType\ArrayOfPvObjectRightData
     */
    public function setPvObjectRightData(array $pvObjectRightData = array())
    {
        // validation for constraint: array
        if ('' !== ($pvObjectRightDataArrayErrorMessage = self::validatePvObjectRightDataForArrayConstraintsFromSetPvObjectRightData($pvObjectRightData))) {
            throw new \InvalidArgumentException($pvObjectRightDataArrayErrorMessage, __LINE__);
        }
        if (is_null($pvObjectRightData) || (is_array($pvObjectRightData) && empty($pvObjectRightData))) {
            unset($this->PvObjectRightData);
        } else {
            $this->PvObjectRightData = $pvObjectRightData;
        }
        return $this;
    }
    /**
     * Add item to PvObjectRightData value
     * @throws \InvalidArgumentException
     * @param \StructType\PvObjectRightData $item
     * @return \ArrayType\ArrayOfPvObjectRightData
     */
    public function addToPvObjectRightData(\StructType\PvObjectRightData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PvObjectRightData) {
            throw new \InvalidArgumentException(sprintf('The PvObjectRightData property can only contain items of type \StructType\PvObjectRightData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PvObjectRightData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PvObjectRightData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PvObjectRightData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PvObjectRightData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PvObjectRightData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PvObjectRightData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PvObjectRightData
     */
    public function getAttributeName()
    {
        return 'PvObjectRightData';
    }
}
