<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPvNotificationData ArrayType
 * @subpackage Arrays
 */
class ArrayOfPvNotificationData extends AbstractStructArrayBase
{
    /**
     * The PvNotificationData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PvNotificationData[]
     */
    public $PvNotificationData;
    /**
     * Constructor method for ArrayOfPvNotificationData
     * @uses ArrayOfPvNotificationData::setPvNotificationData()
     * @param \StructType\PvNotificationData[] $pvNotificationData
     */
    public function __construct(array $pvNotificationData = array())
    {
        $this
            ->setPvNotificationData($pvNotificationData);
    }
    /**
     * Get PvNotificationData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PvNotificationData[]|null
     */
    public function getPvNotificationData()
    {
        return isset($this->PvNotificationData) ? $this->PvNotificationData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPvNotificationData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPvNotificationData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePvNotificationDataForArrayConstraintsFromSetPvNotificationData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPvNotificationDataPvNotificationDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfPvNotificationDataPvNotificationDataItem instanceof \StructType\PvNotificationData) {
                $invalidValues[] = is_object($arrayOfPvNotificationDataPvNotificationDataItem) ? get_class($arrayOfPvNotificationDataPvNotificationDataItem) : sprintf('%s(%s)', gettype($arrayOfPvNotificationDataPvNotificationDataItem), var_export($arrayOfPvNotificationDataPvNotificationDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PvNotificationData property can only contain items of type \StructType\PvNotificationData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PvNotificationData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PvNotificationData[] $pvNotificationData
     * @return \ArrayType\ArrayOfPvNotificationData
     */
    public function setPvNotificationData(array $pvNotificationData = array())
    {
        // validation for constraint: array
        if ('' !== ($pvNotificationDataArrayErrorMessage = self::validatePvNotificationDataForArrayConstraintsFromSetPvNotificationData($pvNotificationData))) {
            throw new \InvalidArgumentException($pvNotificationDataArrayErrorMessage, __LINE__);
        }
        if (is_null($pvNotificationData) || (is_array($pvNotificationData) && empty($pvNotificationData))) {
            unset($this->PvNotificationData);
        } else {
            $this->PvNotificationData = $pvNotificationData;
        }
        return $this;
    }
    /**
     * Add item to PvNotificationData value
     * @throws \InvalidArgumentException
     * @param \StructType\PvNotificationData $item
     * @return \ArrayType\ArrayOfPvNotificationData
     */
    public function addToPvNotificationData(\StructType\PvNotificationData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PvNotificationData) {
            throw new \InvalidArgumentException(sprintf('The PvNotificationData property can only contain items of type \StructType\PvNotificationData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PvNotificationData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PvNotificationData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PvNotificationData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PvNotificationData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PvNotificationData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PvNotificationData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PvNotificationData
     */
    public function getAttributeName()
    {
        return 'PvNotificationData';
    }
}
