<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPvMenuItemData ArrayType
 * @subpackage Arrays
 */
class ArrayOfPvMenuItemData extends AbstractStructArrayBase
{
    /**
     * The PvMenuItemData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PvMenuItemData[]
     */
    public $PvMenuItemData;
    /**
     * Constructor method for ArrayOfPvMenuItemData
     * @uses ArrayOfPvMenuItemData::setPvMenuItemData()
     * @param \StructType\PvMenuItemData[] $pvMenuItemData
     */
    public function __construct(array $pvMenuItemData = array())
    {
        $this
            ->setPvMenuItemData($pvMenuItemData);
    }
    /**
     * Get PvMenuItemData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PvMenuItemData[]|null
     */
    public function getPvMenuItemData()
    {
        return isset($this->PvMenuItemData) ? $this->PvMenuItemData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPvMenuItemData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPvMenuItemData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePvMenuItemDataForArrayConstraintsFromSetPvMenuItemData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPvMenuItemDataPvMenuItemDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfPvMenuItemDataPvMenuItemDataItem instanceof \StructType\PvMenuItemData) {
                $invalidValues[] = is_object($arrayOfPvMenuItemDataPvMenuItemDataItem) ? get_class($arrayOfPvMenuItemDataPvMenuItemDataItem) : sprintf('%s(%s)', gettype($arrayOfPvMenuItemDataPvMenuItemDataItem), var_export($arrayOfPvMenuItemDataPvMenuItemDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PvMenuItemData property can only contain items of type \StructType\PvMenuItemData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PvMenuItemData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PvMenuItemData[] $pvMenuItemData
     * @return \ArrayType\ArrayOfPvMenuItemData
     */
    public function setPvMenuItemData(array $pvMenuItemData = array())
    {
        // validation for constraint: array
        if ('' !== ($pvMenuItemDataArrayErrorMessage = self::validatePvMenuItemDataForArrayConstraintsFromSetPvMenuItemData($pvMenuItemData))) {
            throw new \InvalidArgumentException($pvMenuItemDataArrayErrorMessage, __LINE__);
        }
        if (is_null($pvMenuItemData) || (is_array($pvMenuItemData) && empty($pvMenuItemData))) {
            unset($this->PvMenuItemData);
        } else {
            $this->PvMenuItemData = $pvMenuItemData;
        }
        return $this;
    }
    /**
     * Add item to PvMenuItemData value
     * @throws \InvalidArgumentException
     * @param \StructType\PvMenuItemData $item
     * @return \ArrayType\ArrayOfPvMenuItemData
     */
    public function addToPvMenuItemData(\StructType\PvMenuItemData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PvMenuItemData) {
            throw new \InvalidArgumentException(sprintf('The PvMenuItemData property can only contain items of type \StructType\PvMenuItemData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PvMenuItemData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PvMenuItemData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PvMenuItemData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PvMenuItemData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PvMenuItemData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PvMenuItemData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PvMenuItemData
     */
    public function getAttributeName()
    {
        return 'PvMenuItemData';
    }
}
