<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPvMarkData ArrayType
 * @subpackage Arrays
 */
class ArrayOfPvMarkData extends AbstractStructArrayBase
{
    /**
     * The PvMarkData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PvMarkData[]
     */
    public $PvMarkData;
    /**
     * Constructor method for ArrayOfPvMarkData
     * @uses ArrayOfPvMarkData::setPvMarkData()
     * @param \StructType\PvMarkData[] $pvMarkData
     */
    public function __construct(array $pvMarkData = array())
    {
        $this
            ->setPvMarkData($pvMarkData);
    }
    /**
     * Get PvMarkData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PvMarkData[]|null
     */
    public function getPvMarkData()
    {
        return isset($this->PvMarkData) ? $this->PvMarkData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPvMarkData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPvMarkData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePvMarkDataForArrayConstraintsFromSetPvMarkData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPvMarkDataPvMarkDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfPvMarkDataPvMarkDataItem instanceof \StructType\PvMarkData) {
                $invalidValues[] = is_object($arrayOfPvMarkDataPvMarkDataItem) ? get_class($arrayOfPvMarkDataPvMarkDataItem) : sprintf('%s(%s)', gettype($arrayOfPvMarkDataPvMarkDataItem), var_export($arrayOfPvMarkDataPvMarkDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PvMarkData property can only contain items of type \StructType\PvMarkData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PvMarkData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PvMarkData[] $pvMarkData
     * @return \ArrayType\ArrayOfPvMarkData
     */
    public function setPvMarkData(array $pvMarkData = array())
    {
        // validation for constraint: array
        if ('' !== ($pvMarkDataArrayErrorMessage = self::validatePvMarkDataForArrayConstraintsFromSetPvMarkData($pvMarkData))) {
            throw new \InvalidArgumentException($pvMarkDataArrayErrorMessage, __LINE__);
        }
        if (is_null($pvMarkData) || (is_array($pvMarkData) && empty($pvMarkData))) {
            unset($this->PvMarkData);
        } else {
            $this->PvMarkData = $pvMarkData;
        }
        return $this;
    }
    /**
     * Add item to PvMarkData value
     * @throws \InvalidArgumentException
     * @param \StructType\PvMarkData $item
     * @return \ArrayType\ArrayOfPvMarkData
     */
    public function addToPvMarkData(\StructType\PvMarkData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PvMarkData) {
            throw new \InvalidArgumentException(sprintf('The PvMarkData property can only contain items of type \StructType\PvMarkData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PvMarkData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PvMarkData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PvMarkData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PvMarkData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PvMarkData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PvMarkData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PvMarkData
     */
    public function getAttributeName()
    {
        return 'PvMarkData';
    }
}
