<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPvLabelItemData ArrayType
 * @subpackage Arrays
 */
class ArrayOfPvLabelItemData extends AbstractStructArrayBase
{
    /**
     * The PvLabelItemData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PvLabelItemData[]
     */
    public $PvLabelItemData;
    /**
     * Constructor method for ArrayOfPvLabelItemData
     * @uses ArrayOfPvLabelItemData::setPvLabelItemData()
     * @param \StructType\PvLabelItemData[] $pvLabelItemData
     */
    public function __construct(array $pvLabelItemData = array())
    {
        $this
            ->setPvLabelItemData($pvLabelItemData);
    }
    /**
     * Get PvLabelItemData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PvLabelItemData[]|null
     */
    public function getPvLabelItemData()
    {
        return isset($this->PvLabelItemData) ? $this->PvLabelItemData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPvLabelItemData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPvLabelItemData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePvLabelItemDataForArrayConstraintsFromSetPvLabelItemData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPvLabelItemDataPvLabelItemDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfPvLabelItemDataPvLabelItemDataItem instanceof \StructType\PvLabelItemData) {
                $invalidValues[] = is_object($arrayOfPvLabelItemDataPvLabelItemDataItem) ? get_class($arrayOfPvLabelItemDataPvLabelItemDataItem) : sprintf('%s(%s)', gettype($arrayOfPvLabelItemDataPvLabelItemDataItem), var_export($arrayOfPvLabelItemDataPvLabelItemDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PvLabelItemData property can only contain items of type \StructType\PvLabelItemData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PvLabelItemData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PvLabelItemData[] $pvLabelItemData
     * @return \ArrayType\ArrayOfPvLabelItemData
     */
    public function setPvLabelItemData(array $pvLabelItemData = array())
    {
        // validation for constraint: array
        if ('' !== ($pvLabelItemDataArrayErrorMessage = self::validatePvLabelItemDataForArrayConstraintsFromSetPvLabelItemData($pvLabelItemData))) {
            throw new \InvalidArgumentException($pvLabelItemDataArrayErrorMessage, __LINE__);
        }
        if (is_null($pvLabelItemData) || (is_array($pvLabelItemData) && empty($pvLabelItemData))) {
            unset($this->PvLabelItemData);
        } else {
            $this->PvLabelItemData = $pvLabelItemData;
        }
        return $this;
    }
    /**
     * Add item to PvLabelItemData value
     * @throws \InvalidArgumentException
     * @param \StructType\PvLabelItemData $item
     * @return \ArrayType\ArrayOfPvLabelItemData
     */
    public function addToPvLabelItemData(\StructType\PvLabelItemData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PvLabelItemData) {
            throw new \InvalidArgumentException(sprintf('The PvLabelItemData property can only contain items of type \StructType\PvLabelItemData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PvLabelItemData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PvLabelItemData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PvLabelItemData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PvLabelItemData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PvLabelItemData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PvLabelItemData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PvLabelItemData
     */
    public function getAttributeName()
    {
        return 'PvLabelItemData';
    }
}
