<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPvCountryData ArrayType
 * @subpackage Arrays
 */
class ArrayOfPvCountryData extends AbstractStructArrayBase
{
    /**
     * The PvCountryData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PvCountryData[]
     */
    public $PvCountryData;
    /**
     * Constructor method for ArrayOfPvCountryData
     * @uses ArrayOfPvCountryData::setPvCountryData()
     * @param \StructType\PvCountryData[] $pvCountryData
     */
    public function __construct(array $pvCountryData = array())
    {
        $this
            ->setPvCountryData($pvCountryData);
    }
    /**
     * Get PvCountryData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PvCountryData[]|null
     */
    public function getPvCountryData()
    {
        return isset($this->PvCountryData) ? $this->PvCountryData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPvCountryData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPvCountryData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePvCountryDataForArrayConstraintsFromSetPvCountryData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPvCountryDataPvCountryDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfPvCountryDataPvCountryDataItem instanceof \StructType\PvCountryData) {
                $invalidValues[] = is_object($arrayOfPvCountryDataPvCountryDataItem) ? get_class($arrayOfPvCountryDataPvCountryDataItem) : sprintf('%s(%s)', gettype($arrayOfPvCountryDataPvCountryDataItem), var_export($arrayOfPvCountryDataPvCountryDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PvCountryData property can only contain items of type \StructType\PvCountryData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PvCountryData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PvCountryData[] $pvCountryData
     * @return \ArrayType\ArrayOfPvCountryData
     */
    public function setPvCountryData(array $pvCountryData = array())
    {
        // validation for constraint: array
        if ('' !== ($pvCountryDataArrayErrorMessage = self::validatePvCountryDataForArrayConstraintsFromSetPvCountryData($pvCountryData))) {
            throw new \InvalidArgumentException($pvCountryDataArrayErrorMessage, __LINE__);
        }
        if (is_null($pvCountryData) || (is_array($pvCountryData) && empty($pvCountryData))) {
            unset($this->PvCountryData);
        } else {
            $this->PvCountryData = $pvCountryData;
        }
        return $this;
    }
    /**
     * Add item to PvCountryData value
     * @throws \InvalidArgumentException
     * @param \StructType\PvCountryData $item
     * @return \ArrayType\ArrayOfPvCountryData
     */
    public function addToPvCountryData(\StructType\PvCountryData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PvCountryData) {
            throw new \InvalidArgumentException(sprintf('The PvCountryData property can only contain items of type \StructType\PvCountryData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PvCountryData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PvCountryData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PvCountryData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PvCountryData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PvCountryData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PvCountryData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PvCountryData
     */
    public function getAttributeName()
    {
        return 'PvCountryData';
    }
}
