<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPvActivityData ArrayType
 * @subpackage Arrays
 */
class ArrayOfPvActivityData extends AbstractStructArrayBase
{
    /**
     * The PvActivityData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PvActivityData[]
     */
    public $PvActivityData;
    /**
     * Constructor method for ArrayOfPvActivityData
     * @uses ArrayOfPvActivityData::setPvActivityData()
     * @param \StructType\PvActivityData[] $pvActivityData
     */
    public function __construct(array $pvActivityData = array())
    {
        $this
            ->setPvActivityData($pvActivityData);
    }
    /**
     * Get PvActivityData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PvActivityData[]|null
     */
    public function getPvActivityData()
    {
        return isset($this->PvActivityData) ? $this->PvActivityData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPvActivityData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPvActivityData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePvActivityDataForArrayConstraintsFromSetPvActivityData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPvActivityDataPvActivityDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfPvActivityDataPvActivityDataItem instanceof \StructType\PvActivityData) {
                $invalidValues[] = is_object($arrayOfPvActivityDataPvActivityDataItem) ? get_class($arrayOfPvActivityDataPvActivityDataItem) : sprintf('%s(%s)', gettype($arrayOfPvActivityDataPvActivityDataItem), var_export($arrayOfPvActivityDataPvActivityDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PvActivityData property can only contain items of type \StructType\PvActivityData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PvActivityData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PvActivityData[] $pvActivityData
     * @return \ArrayType\ArrayOfPvActivityData
     */
    public function setPvActivityData(array $pvActivityData = array())
    {
        // validation for constraint: array
        if ('' !== ($pvActivityDataArrayErrorMessage = self::validatePvActivityDataForArrayConstraintsFromSetPvActivityData($pvActivityData))) {
            throw new \InvalidArgumentException($pvActivityDataArrayErrorMessage, __LINE__);
        }
        if (is_null($pvActivityData) || (is_array($pvActivityData) && empty($pvActivityData))) {
            unset($this->PvActivityData);
        } else {
            $this->PvActivityData = $pvActivityData;
        }
        return $this;
    }
    /**
     * Add item to PvActivityData value
     * @throws \InvalidArgumentException
     * @param \StructType\PvActivityData $item
     * @return \ArrayType\ArrayOfPvActivityData
     */
    public function addToPvActivityData(\StructType\PvActivityData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PvActivityData) {
            throw new \InvalidArgumentException(sprintf('The PvActivityData property can only contain items of type \StructType\PvActivityData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PvActivityData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PvActivityData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PvActivityData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PvActivityData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PvActivityData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PvActivityData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PvActivityData
     */
    public function getAttributeName()
    {
        return 'PvActivityData';
    }
}
