<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for timings StructType
 * @subpackage Structs
 */
class Timings extends AbstractStructBase
{
    /**
     * The start
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $start;
    /**
     * The duration
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $duration;
    /**
     * The end
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $end;
    /**
     * Constructor method for timings
     * @uses Timings::setStart()
     * @uses Timings::setDuration()
     * @uses Timings::setEnd()
     * @param string $start
     * @param string $duration
     * @param string $end
     */
    public function __construct($start = null, $duration = null, $end = null)
    {
        $this
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end);
    }
    /**
     * Get start value
     * @return string
     */
    public function getStart()
    {
        return $this->start;
    }
    /**
     * Set start value
     * @param string $start
     * @return \StructType\Timings
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->start = $start;
        return $this;
    }
    /**
     * Get duration value
     * @return string
     */
    public function getDuration()
    {
        return $this->duration;
    }
    /**
     * Set duration value
     * @param string $duration
     * @return \StructType\Timings
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->duration = $duration;
        return $this;
    }
    /**
     * Get end value
     * @return string
     */
    public function getEnd()
    {
        return $this->end;
    }
    /**
     * Set end value
     * @param string $end
     * @return \StructType\Timings
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->end = $end;
        return $this;
    }
}
